/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public interface FeatureHolder
extends Changeable {
    public static final ChangeType FEATURES = new ChangeType("Features have been added or removed", "org.biojava.bio.seq.FeatureHolder", "FEATURES");
    public static final FeatureHolder EMPTY_FEATURE_HOLDER = new EmptyFeatureHolder();

    public int countFeatures();

    public Iterator features();

    public FeatureHolder filter(FeatureFilter var1, boolean var2);

    public Feature createFeature(Feature.Template var1) throws BioException, ChangeVetoException;

    public void removeFeature(Feature var1) throws ChangeVetoException;

    public boolean containsFeature(Feature var1);

    public static final class EmptyFeatureHolder
    implements FeatureHolder {
        public int countFeatures() {
            return 0;
        }

        public Iterator features() {
            return Collections.EMPTY_SET.iterator();
        }

        public FeatureHolder filter(FeatureFilter fc, boolean recurse) {
            return this;
        }

        public Feature createFeature(Feature.Template f) {
            throw new UnsupportedOperationException();
        }

        public void removeFeature(Feature f) {
            throw new UnsupportedOperationException();
        }

        public boolean containsFeature(Feature f) {
            return false;
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }
    }
}

