/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolPropertyTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProteinTools {
    private static final FiniteAlphabet proteinAlpha;
    private static final FiniteAlphabet proteinTAlpha;
    private static final Map propertyTableMap;
    static /* synthetic */ Class class$org$biojava$bio$seq$ProteinTools;

    public static final FiniteAlphabet getAlphabet() {
        return proteinAlpha;
    }

    public static final FiniteAlphabet getTAlphabet() {
        return proteinTAlpha;
    }

    public static final SymbolPropertyTable getSymbolPropertyTable(String name) {
        return (SymbolPropertyTable)propertyTableMap.get(name);
    }

    public static SymbolList createProtein(String theProtein) throws IllegalSymbolException {
        try {
            SymbolParser p = ProteinTools.getTAlphabet().getParser("token");
            return p.parse(theProtein);
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with Protein");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        propertyTableMap = new HashMap();
        try {
            proteinAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
            proteinTAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN-TERM");
        }
        catch (Exception e) {
            throw new BioError(e, " Could not initialize ProteinTools");
        }
        Document doc = null;
        try {
            InputStream tablesStream = (class$org$biojava$bio$seq$ProteinTools == null ? (class$org$biojava$bio$seq$ProteinTools = ProteinTools.class$("org.biojava.bio.seq.ProteinTools")) : class$org$biojava$bio$seq$ProteinTools).getClassLoader().getResourceAsStream("org/biojava/bio/symbol/ResidueProperties.xml");
            if (tablesStream == null) {
                throw new BioError("Couldn't locate ResidueProperties.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(is);
        }
        catch (MissingResourceException mre) {
            System.err.println(mre.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String value;
            Element el;
            String name;
            int j;
            NodeList properyNodes;
            Element child;
            Node cnode;
            int i;
            Symbol s;
            SimpleSymbolPropertyTable simplePropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "monoMass");
            Iterator it = ProteinTools.getAlphabet().iterator();
            NodeList children = doc.getDocumentElement().getChildNodes();
            while (it.hasNext()) {
                s = (Symbol)it.next();
                i = 0;
                while (i < children.getLength()) {
                    cnode = children.item(i);
                    if (cnode instanceof Element && (child = (Element)cnode).getNodeName().equals("residue") && child.getAttribute("token").equals(s.getToken() + "")) {
                        properyNodes = child.getChildNodes();
                        j = 0;
                        while (j < properyNodes.getLength()) {
                            cnode = properyNodes.item(j);
                            if (cnode instanceof Element && (name = (el = (Element)cnode).getAttribute("name")).equals("monoMass")) {
                                value = el.getAttribute("value");
                                simplePropertyTable.setDoubleProperty(s, value);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            propertyTableMap.put("monoMass", simplePropertyTable);
            simplePropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "avgMass");
            it = ProteinTools.getAlphabet().iterator();
            while (it.hasNext()) {
                s = (Symbol)it.next();
                i = 0;
                while (i < children.getLength()) {
                    cnode = children.item(i);
                    if (cnode instanceof Element && (child = (Element)cnode).getNodeName().equals("residue") && child.getAttribute("token").equals(s.getToken() + "")) {
                        properyNodes = child.getChildNodes();
                        j = 0;
                        while (j < properyNodes.getLength()) {
                            cnode = properyNodes.item(j);
                            if (cnode instanceof Element && (name = (el = (Element)cnode).getAttribute("name")).equals("avgMass")) {
                                value = el.getAttribute("value");
                                simplePropertyTable.setDoubleProperty(s, value);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            propertyTableMap.put("avgMass", simplePropertyTable);
        }
        catch (Exception e) {
            throw new BioError(e, " Could not initialize ProteinTools");
        }
    }
}

