/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class HashSequenceDB
implements SequenceDB,
Serializable {
    private final Map sequenceByID = new HashMap();
    private final IDMaker idMaker;
    private String name;
    protected transient ChangeSupport changeSupport = null;

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public String getName() {
        return this.name;
    }

    public Sequence getSequence(String id) {
        return (Sequence)this.sequenceByID.get(id);
    }

    public Set ids() {
        return this.sequenceByID.keySet();
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            Iterator seqI;
            {
                this.seqI = HashSequenceDB.this.sequenceByID.values().iterator();
            }

            public boolean hasNext() {
                return this.seqI.hasNext();
            }

            public Sequence nextSequence() {
                return (Sequence)this.seqI.next();
            }
        };
    }

    public void addSequence(String id, Sequence seq) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.sequenceByID.put(id, seq);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceDBLite.SEQUENCES, new Object[]{id, seq}, null);
                this.changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.put(id, seq);
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public IDMaker getIDMaker() {
        return this.idMaker;
    }

    public void addSequence(Sequence seq) throws ChangeVetoException {
        String id = this.idMaker.calcID(seq);
        this.addSequence(id, seq);
    }

    public void removeSequence(String id) throws BioException, ChangeVetoException {
        if (this.changeSupport == null) {
            this.sequenceByID.remove(id);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceDBLite.SEQUENCES, null, id);
                this.changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.remove(id);
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.generateChangeSupport(null);
        this.changeSupport.addChangeListener(cl);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.generateChangeSupport(ct);
        this.changeSupport.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeSupport.removeChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.changeSupport.removeChangeListener(cl, ct);
    }

    public HashSequenceDB() {
        this(IDMaker.byName, null);
    }

    public HashSequenceDB(IDMaker idMaker) {
        this(idMaker, null);
    }

    public HashSequenceDB(String name) {
        this(IDMaker.byName, name);
    }

    public HashSequenceDB(IDMaker idMaker, String name) {
        this.idMaker = idMaker;
        this.name = name;
    }
}

