/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.emblcd;

class RecordParser {
    private byte[] fNumBytes = new byte[2];
    private byte[] rPosBytes = new byte[4];
    private byte[] sPosBytes = new byte[4];
    private byte[] recNumBytes = new byte[4];
    private byte[] recTotBytes = new byte[4];
    private StringBuffer sb = new StringBuffer(512);

    RecordParser() {
    }

    long parseInt4(byte[] int4) {
        int result = 0;
        int i = 4;
        while (--i >= 0) {
            if (int4[i] == 0) continue;
            result += (int4[i] & 0xFF) << 8 * i;
        }
        return result;
    }

    int parseInt2(byte[] int2) {
        int result = 0;
        int i = 2;
        while (--i >= 0) {
            if (int2[i] == 0) continue;
            result += (int2[i] & 0xFF) << 8 * i;
        }
        return result;
    }

    String parseDate(StringBuffer sb, byte[] dbDate) {
        int i = dbDate.length;
        while (--i > 0) {
            sb.append(dbDate[i] + ":");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    String parseString(StringBuffer sb, byte[] characters) {
        int i = 0;
        while (i < characters.length) {
            if (characters[i] == 0) break;
            sb.append((char)characters[i]);
            ++i;
        }
        return sb.toString();
    }

    Object[] parseDivRecord(byte[] divRecord) {
        int nameLen = divRecord.length - 2;
        byte[] fNameBytes = new byte[nameLen];
        System.arraycopy(divRecord, 0, this.fNumBytes, 0, 2);
        System.arraycopy(divRecord, 2, fNameBytes, 0, nameLen);
        this.sb.setLength(0);
        Integer fileNumber = new Integer(this.parseInt2(this.fNumBytes));
        String fileName = this.parseString(this.sb, fNameBytes);
        return new Object[]{fileNumber, fileName};
    }

    Object[] parseEntryNamRecord(byte[] enRecord) {
        int idLen = enRecord.length - 10;
        byte[] idBytes = new byte[idLen];
        System.arraycopy(enRecord, 0, idBytes, 0, idLen);
        System.arraycopy(enRecord, idLen, this.rPosBytes, 0, 4);
        System.arraycopy(enRecord, idLen + 4, this.sPosBytes, 0, 4);
        System.arraycopy(enRecord, idLen + 8, this.fNumBytes, 0, 2);
        this.sb.setLength(0);
        String seqID = this.parseString(this.sb, idBytes);
        Long rPosition = new Long(this.parseInt4(this.rPosBytes));
        Long sPosition = new Long(this.parseInt4(this.sPosBytes));
        Integer fileNumber = new Integer(this.parseInt2(this.fNumBytes));
        return new Object[]{seqID, rPosition, sPosition, fileNumber};
    }

    Object[] parseAcnumTrgRecord(byte[] acRecord) {
        int accLen = acRecord.length - 8;
        byte[] accBytes = new byte[accLen];
        System.arraycopy(acRecord, 0, this.recNumBytes, 0, 4);
        System.arraycopy(acRecord, 4, this.recTotBytes, 0, 4);
        System.arraycopy(acRecord, 8, accBytes, 0, accLen);
        this.sb.setLength(0);
        Long rNumber = new Long(this.parseInt4(this.recNumBytes));
        Long rTotal = new Long(this.parseInt4(this.recTotBytes));
        String seqAcc = this.parseString(this.sb, accBytes);
        return new Object[]{rNumber, rTotal, seqAcc};
    }

    Object[] parseAcnumHitRecord(byte[] rnRecord) {
        System.arraycopy(rnRecord, 0, this.recNumBytes, 0, 4);
        Long rNumber = new Long(this.parseInt4(this.recNumBytes));
        return new Object[]{rNumber};
    }
}

