/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.AbstractGenEmblFileFormer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SeqFileFormerFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

public class EmblFileFormer
extends AbstractGenEmblFileFormer
implements SeqFileFormer {
    private ArrayList fStack = new ArrayList();
    private PrintStream stream;
    private StringBuffer sq = new StringBuffer();
    private StringBuffer qb = new StringBuffer();
    private StringBuffer ub = new StringBuffer();
    static /* synthetic */ Class class$java$util$Collection;

    private EmblFileFormer() {
    }

    private EmblFileFormer(PrintStream stream) {
        this.stream = stream;
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    public void setPrintStream(PrintStream stream) {
        this.stream = stream;
    }

    public void setName(String id) throws ParseException {
    }

    public void startSequence() throws ParseException {
    }

    public void endSequence() throws ParseException {
    }

    public void setURI(String uri) throws ParseException {
    }

    public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) throws IllegalAlphabetException {
        int aCount = 0;
        int cCount = 0;
        int gCount = 0;
        int tCount = 0;
        int oCount = 0;
        int end = start + length - 1;
        int i = start;
        while (i <= end) {
            char c = syms[i].getToken();
            switch (c) {
                case 'A': 
                case 'a': {
                    ++aCount;
                    break;
                }
                case 'C': 
                case 'c': {
                    ++cCount;
                    break;
                }
                case 'G': 
                case 'g': {
                    ++gCount;
                    break;
                }
                case 'T': 
                case 't': {
                    ++tCount;
                    break;
                }
                default: {
                    ++oCount;
                }
            }
            ++i;
        }
        String nl = System.getProperty("line.separator");
        this.sq.setLength(0);
        this.sq.append("XX");
        this.sq.append(nl);
        this.sq.append("SQ   Sequence ");
        this.sq.append(length + " BP; ");
        this.sq.append(aCount + " A; ");
        this.sq.append(cCount + " C; ");
        this.sq.append(gCount + " G; ");
        this.sq.append(tCount + " T; ");
        this.sq.append(oCount + " other;");
        this.stream.println(this.sq);
        int fullLine = length / 60;
        int partLine = length % 60;
        int lineCount = fullLine;
        if (partLine > 0) {
            ++lineCount;
        }
        int[] lineLens = new int[lineCount];
        Arrays.fill(lineLens, 60);
        lineLens[lineCount - 1] = partLine;
        char[] emptyLine = new char[80];
        int i2 = 0;
        while (i2 < lineLens.length) {
            this.sq.setLength(0);
            this.ub.setLength(0);
            int len = lineLens[i2];
            Arrays.fill(emptyLine, ' ');
            this.sq.append(emptyLine);
            Symbol[] sa = new Symbol[len];
            System.arraycopy(syms, start + i2 * 60, sa, 0, len);
            String blocks = this.formatTokenBlock(this.ub, sa, 10).toString();
            this.sq.replace(5, blocks.length() + 5, blocks);
            String count = Integer.toString(i2 * 60 + len);
            this.sq.replace(80 - count.length(), 80, count);
            this.stream.println(this.sq);
            ++i2;
        }
        this.stream.println("//");
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        if (key.equals("embl_accessions")) {
            this.ub.setLength(0);
            this.ub.append("AC   ");
            Iterator ai = ((List)value).iterator();
            while (ai.hasNext()) {
                this.ub.append((String)ai.next());
                this.ub.append(";");
            }
            this.stream.println(this.ub);
        }
    }

    public void startFeature(Feature.Template templ) throws ParseException {
        String leader = "FT                   ";
        int strand = 0;
        if (templ instanceof StrandedFeature.Template) {
            strand = ((StrandedFeature.Template)templ).strand.getValue();
        }
        this.ub.setLength(0);
        this.ub.append(leader);
        StringBuffer lb = this.formatLocationBlock(this.ub, templ.location, strand, leader, 80);
        lb.replace(5, 5 + templ.type.length(), templ.type);
        this.stream.println(lb);
    }

    public void endFeature() throws ParseException {
    }

    public void addFeatureProperty(Object key, Object value) throws ParseException {
        String leader = "FT                   ";
        if (key.equals("internal_data")) {
            return;
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = EmblFileFormer.class$("java.util.Collection")) : class$java$util$Collection).isInstance(value)) {
            Iterator vi = ((Collection)value).iterator();
            while (vi.hasNext()) {
                this.qb.setLength(0);
                this.ub.setLength(0);
                StringBuffer fb = this.formatQualifierBlock(this.qb, this.formatQualifier(this.ub, key, vi.next()).toString(), leader, 80);
                this.stream.println(fb);
            }
        } else {
            this.qb.setLength(0);
            this.ub.setLength(0);
            StringBuffer fb = this.formatQualifierBlock(this.qb, this.formatQualifier(this.ub, key, value).toString(), leader, 80);
            this.stream.println(fb);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SeqFileFormerFactory.addFactory("Embl", new Factory());
    }

    private static class Factory
    extends SeqFileFormerFactory {
        private Factory() {
        }

        protected SeqFileFormer make() {
            return new EmblFileFormer(System.out);
        }
    }
}

