/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SeqFileFormerFactory;
import org.biojava.bio.seq.io.SeqIOEventEmitter;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

public class EmblLikeFormat
implements SequenceFormat,
Serializable {
    private boolean elideSymbols = false;
    static /* synthetic */ Class class$org$biojava$bio$seq$io$EmblLikeFormat;

    public void setElideSymbols(boolean b) {
        this.elideSymbols = b;
    }

    public boolean getElideSymbols() {
        return this.elideSymbols;
    }

    /*
     * WARNING - void declaration
     */
    public boolean readSequence(BufferedReader reader, SymbolParser symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        String line;
        StreamParser sparser = null;
        boolean hasMoreSequence = true;
        boolean hasInternalWhitespace = false;
        listener.startSequence();
        while ((line = reader.readLine()) != null) {
            void var4_7;
            if (var4_7.startsWith("//")) {
                block10: {
                    if (sparser != null) {
                        sparser.close();
                        sparser = null;
                    }
                    char[] cbuf = new char[1];
                    while (true) {
                        reader.mark(1);
                        if (reader.read() == -1) {
                            hasMoreSequence = false;
                            break block10;
                        }
                        reader.read(cbuf, 0, 1);
                        if (!Character.isWhitespace(cbuf[0])) break;
                        hasInternalWhitespace = true;
                    }
                    if (hasInternalWhitespace) {
                        System.err.println("Warning: whitespace found between sequence entries");
                    }
                    reader.reset();
                }
                listener.endSequence();
                return hasMoreSequence;
            }
            if (var4_7.startsWith("SQ")) {
                listener.addSequenceProperty("XX", "");
                sparser = symParser.parseStream(listener);
                continue;
            }
            if (sparser == null) {
                String tag = var4_7.substring(0, 2);
                String rest = null;
                if (var4_7.length() > 5) {
                    rest = var4_7.substring(5);
                }
                listener.addSequenceProperty(tag, rest);
                continue;
            }
            if (this.elideSymbols) continue;
            this.processSequenceLine((String)var4_7, sparser);
        }
        if (sparser != null) {
            sparser.close();
        }
        throw new IOException("Premature end of stream or missing end tag '//' for EMBL");
    }

    /*
     * Unable to fully structure code
     */
    protected void processSequenceLine(String line, StreamParser parser) throws IllegalSymbolException, ParseException {
        cline = line.toCharArray();
        parseStart = 0;
        parseEnd = 0;
        ** GOTO lbl17
        {
            ++parseStart;
            do {
                if (parseStart < cline.length && cline[parseStart] == ' ') continue block0;
                if (parseStart >= cline.length) break block0;
                if (Character.isDigit(cline[parseStart])) {
                    return;
                }
                parseEnd = parseStart + 1;
                while (parseEnd < cline.length && cline[parseEnd] != ' ') {
                    ++parseEnd;
                }
                parser.characters(cline, parseStart, parseEnd - parseStart);
                parseStart = parseEnd;
lbl17:
                // 2 sources

            } while (parseStart < cline.length);
        }
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        String defaultFormat = this.getDefaultFormat();
        try {
            SeqFileFormer former = SeqFileFormerFactory.makeFormer(defaultFormat);
            former.setPrintStream(os);
            SeqIOEventEmitter.getSeqIOEvents(seq, former);
        }
        catch (BioException be) {
            throw new IOException(be.getMessage());
        }
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        String requestedFormat = new String(format);
        boolean found = false;
        String[] formats = this.getFormats().toArray(new String[0]);
        int i = 0;
        while (i < formats.length) {
            if (formats[i].equalsIgnoreCase(format)) {
                requestedFormat = formats[i];
                found = true;
            }
            ++i;
        }
        if (!found) {
            throw new IOException("Failed to write: an invalid file format '" + format + "' was requested");
        }
        try {
            SeqFileFormer former = SeqFileFormerFactory.makeFormer(requestedFormat);
            former.setPrintStream(os);
            SeqIOEventEmitter.getSeqIOEvents(seq, former);
        }
        catch (BioException be) {
            throw new IOException(be.getMessage());
        }
    }

    public Set getFormats() {
        return (Set)SequenceFormat.FORMATS.get(this.getClass().getName());
    }

    public String getDefaultFormat() {
        return "Embl";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashSet<String> validFormats = new HashSet<String>();
        validFormats.add("Embl");
        validFormats.add("SwissProt");
        SequenceFormat.FORMATS.put((class$org$biojava$bio$seq$io$EmblLikeFormat == null ? (class$org$biojava$bio$seq$io$EmblLikeFormat = EmblLikeFormat.class$("org.biojava.bio.seq.io.EmblLikeFormat")) : class$org$biojava$bio$seq$io$EmblLikeFormat).getName(), validFormats);
    }
}

