/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.regexp.RE;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.AlignmentFormat;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SymbolList;

public class MSFAlignmentFormat
implements AlignmentFormat {
    private static final boolean DEBUGPRINT = false;

    public static void main(String[] args) {
        String filename = args.length < 1 ? "SimpleMSF.msf" : args[0];
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            MSFAlignmentFormat MSFAlignmentFormat1 = new MSFAlignmentFormat();
            MSFAlignmentFormat1.read(reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Alignment read(BufferedReader reader) {
        Vector<String> sequenceNames = new Vector<String>();
        String sequenceName = null;
        String[] sequenceData = null;
        int startOfData = 0;
        int currSeqCount = 0;
        try {
            RE mtc = new RE("Name:\\s+(.*)\\s+Len:");
            RE removewhitespace = new RE("\\s");
            String line = reader.readLine();
            while (line.indexOf("..") == -1) {
                line = reader.readLine();
            }
            line = reader.readLine();
            line = reader.readLine();
            while (line.indexOf("//") == -1 && line.trim().length() != 0) {
                mtc.match(line);
                sequenceName = line.substring(mtc.getParenStart(1), mtc.getParenEnd(1));
                if (sequenceName == null || line.trim().length() == 0) break;
                sequenceNames.add(sequenceName);
                line = reader.readLine();
            }
            sequenceData = new String[sequenceNames.size()];
            int it = 0;
            while (it < sequenceNames.size()) {
                sequenceData[it] = new String();
                ++it;
            }
            while (line.indexOf((String)sequenceNames.get(0)) == -1) {
                line = reader.readLine();
            }
            while (line != null) {
                currSeqCount = 0;
                while (currSeqCount < sequenceNames.size()) {
                    if (line.indexOf((String)sequenceNames.get(currSeqCount)) == -1) break;
                    startOfData = line.indexOf((String)sequenceNames.get(currSeqCount)) + ((String)sequenceNames.get(currSeqCount)).length();
                    line = line.substring(startOfData);
                    line = removewhitespace.subst(line, "", 0);
                    sequenceData[currSeqCount] = sequenceData[currSeqCount].concat(line);
                    line = reader.readLine();
                    if (line.trim().length() == 0) break;
                    ++currSeqCount;
                }
                while (line != null && line.indexOf((String)sequenceNames.get(0)) == -1) {
                    line = reader.readLine();
                }
            }
            StringBuffer testString = new StringBuffer();
            int agct = 0;
            currSeqCount = 0;
            while (currSeqCount < sequenceNames.size()) {
                testString.append(sequenceData[currSeqCount]);
                ++currSeqCount;
            }
            StringTokenizer st = null;
            st = new StringTokenizer(testString.toString().toLowerCase(), "a");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "g");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "c");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "t");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "u");
            HashMap<String, SymbolList> sequenceDataMap = new HashMap<String, SymbolList>();
            Object sym = null;
            FiniteAlphabet alph = null;
            alph = (double)((agct += st.countTokens()) / testString.length()) > 0.9 ? (st.countTokens() > 0 ? DNATools.getDNA() : DNATools.getDNA()) : ProteinTools.getTAlphabet();
            SymbolParser parse = alph.getParser("token");
            currSeqCount = 0;
            while (currSeqCount < sequenceNames.size()) {
                String sd = null;
                sd = sequenceData[currSeqCount].replace('~', '-');
                sd = sequenceData[currSeqCount].replace('.', '-');
                StringBuffer sb = new StringBuffer();
                Object sl = null;
                sequenceDataMap.put((String)sequenceNames.get(currSeqCount), parse.parse(sd));
                ++currSeqCount;
            }
            return new SimpleAlignment(sequenceDataMap);
        }
        catch (Exception e) {
            System.err.println("MSFFormatReader " + e.getMessage());
            return null;
        }
    }
}

