/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.StreamWriter;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class SeqIOTools {
    private static SequenceBuilderFactory _emblBuilderFactory;
    private static SequenceBuilderFactory _genbankBuilderFactory;
    private static SequenceBuilderFactory _swissprotBuilderFactory;
    private static SequenceBuilderFactory _fastaBuilderFactory;

    private SeqIOTools() {
    }

    private static SymbolParser getDNAParser() {
        try {
            return DNATools.getDNA().getParser("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get DNA token parser");
        }
    }

    private static SymbolParser getProteinParser() {
        try {
            return ProteinTools.getTAlphabet().getParser("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get PROTEIN token parser");
        }
    }

    public static SequenceBuilderFactory getEmblBuilderFactory() {
        if (_emblBuilderFactory == null) {
            _emblBuilderFactory = new EmblProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _emblBuilderFactory;
    }

    public static SequenceIterator readEmbl(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceBuilderFactory getGenbankBuilderFactory() {
        if (_genbankBuilderFactory == null) {
            _genbankBuilderFactory = new GenbankProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _genbankBuilderFactory;
    }

    public static SequenceIterator readGenbank(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new GenbankFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getGenbankBuilderFactory());
    }

    public static SequenceBuilderFactory getSwissprotBuilderFactory() {
        if (_swissprotBuilderFactory == null) {
            _swissprotBuilderFactory = new SwissprotProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _swissprotBuilderFactory;
    }

    public static SequenceIterator readSwissprot(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getSwissprotBuilderFactory());
    }

    public static SequenceBuilderFactory getFastaBuilderFactory() {
        if (_fastaBuilderFactory == null) {
            _fastaBuilderFactory = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _fastaBuilderFactory;
    }

    public static SequenceIterator readFastaDNA(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceIterator readFastaProtein(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceDB readFasta(InputStream seqFile, Alphabet alpha) throws BioException {
        HashSequenceDB db = new HashSequenceDB(IDMaker.byName);
        FastaDescriptionLineParser.Factory sbFact = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
        FastaFormat fFormat = new FastaFormat();
        StreamReader seqI = new StreamReader(seqFile, (SequenceFormat)fFormat, alpha.getParser("token"), (SequenceBuilderFactory)sbFact);
        while (seqI.hasNext()) {
            Sequence seq = seqI.nextSequence();
            try {
                db.addSequence(seq);
            }
            catch (ChangeVetoException cve) {
                throw new NestedError(cve, "Could not successfully add sequence " + seq.getName() + " to sequence database");
            }
        }
        return db;
    }

    public static void writeFasta(OutputStream os, SequenceDB db) throws IOException {
        StreamWriter sw = new StreamWriter(os, new FastaFormat());
        sw.writeStream(db.sequenceIterator());
    }

    public static void writeFasta(OutputStream os, SequenceIterator in) throws IOException {
        StreamWriter sw = new StreamWriter(os, new FastaFormat());
        sw.writeStream(in);
    }
}

