/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.seq.ragbag.RagbagFileParser;
import org.biojava.bio.seq.ragbag.RagbagFileParserFactory;

class RagbagGenbankParser
implements RagbagFileParser {
    public static final RagbagFileParserFactory FACTORY = new RagbagFileParserFactory(){

        public RagbagFileParser getParser(File inputFile) {
            return new RagbagGenbankParser(inputFile);
        }
    };
    public static final String EXTENSION = "gb";
    private SequenceBuilder builder;
    private File inputFile;

    public RagbagGenbankParser(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setListener(SequenceBuilder builder) {
        this.builder = builder;
    }

    public void parse() throws BioException {
        try {
            BufferedReader file = new BufferedReader(new FileReader(this.inputFile));
            GenbankFormat parser = new GenbankFormat();
            SymbolParser dnaParser = DNATools.getDNA().getParser("token");
            GenbankProcessor chain = new GenbankProcessor(this.builder);
            parser.readSequence(file, dnaParser, chain);
        }
        catch (FileNotFoundException fne) {
            throw new BioException(fne);
        }
        catch (IOException ie) {
            throw new BioException(ie);
        }
    }
}

