/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class ChangeForwarder
implements ChangeListener {
    private final Object source;
    private final transient ChangeSupport changeSupport;

    public ChangeForwarder(Object source, ChangeSupport changeSupport) {
        this.source = source;
        this.changeSupport = changeSupport;
    }

    public Object getSource() {
        return this.source;
    }

    public ChangeSupport changeSupport() {
        return this.changeSupport;
    }

    protected ChangeEvent generateEvent(ChangeEvent ce) throws ChangeVetoException {
        return new ChangeEvent(this.getSource(), ce.getType(), null, null, ce);
    }

    public void preChange(ChangeEvent ce) throws ChangeVetoException {
        ChangeEvent nce = this.generateEvent(ce);
        if (nce != null) {
            this.changeSupport.firePreChangeEvent(nce);
        }
    }

    public void postChange(ChangeEvent ce) {
        try {
            ChangeEvent nce = this.generateEvent(ce);
            if (nce != null) {
                this.changeSupport.firePostChangeEvent(nce);
            }
        }
        catch (ChangeVetoException cve) {
            throw new NestedError(cve, "Assertion Failure: Change was vetoed after it had been accepted by preChange");
        }
    }
}

