/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.query.Arc;
import org.biojava.utils.query.Node;

class QueryData {
    protected final Set nodes = new HashSet();
    protected final Map operationsToLabel = new HashMap();
    protected final Map arcsFrom = new HashMap();
    protected final Map arcsTo = new HashMap();

    protected QueryData() {
    }

    protected QueryData(QueryData qd) {
        this.nodes.addAll(qd.nodes);
        this.operationsToLabel.putAll(qd.operationsToLabel);
        this.arcsFrom.putAll(qd.arcsFrom);
        this.arcsTo.putAll(qd.arcsTo);
    }

    public final Set getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public final Set getOperations(Arc arc) {
        Set<Object> ops = (Set)this.operationsToLabel.get(arc);
        ops = ops == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(ops);
        return ops;
    }

    public final Map getArcsToOperators() {
        return Collections.unmodifiableMap(this.operationsToLabel);
    }

    public final Set getArcsFrom(Node from) {
        Set<Object> fromSet = (Set)this.arcsFrom.get(from);
        fromSet = fromSet == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(fromSet);
        return fromSet;
    }

    public final Set getArcsTo(Node to) {
        Set<Object> toSet = (Set)this.arcsTo.get(to);
        toSet = toSet == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(toSet);
        return toSet;
    }
}

