/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.util.Collections;
import java.util.Iterator;
import org.biojava.utils.query.JavaType;
import org.biojava.utils.query.Type;

public interface Queryable {
    public int size();

    public Iterator iterator();

    public Type getItemType();

    public boolean contains(Object var1);

    public static class Singleton
    implements Queryable {
        private Object item;

        public Object getItem() {
            return this.item;
        }

        public Singleton(Object item) {
            this.item = item;
        }

        public int size() {
            return 1;
        }

        public Iterator iterator() {
            return Collections.singleton(this.item).iterator();
        }

        public Type getItemType() {
            return JavaType.getType(this.item.getClass());
        }

        public boolean contains(Object item) {
            return this.item.equals(item);
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public boolean equals(Object o) {
            Queryable that;
            return o instanceof Queryable && (that = (Queryable)o).size() == this.size() && this.item.equals(that.iterator().next());
        }

        public String toString() {
            return "{" + this.item.toString() + "}";
        }
    }

    public static class Empty
    implements Queryable {
        private Type type;

        public Empty(Type type) {
            this.type = type;
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return Collections.EMPTY_SET.iterator();
        }

        public Type getItemType() {
            return this.type;
        }

        public boolean contains(Object item) {
            return false;
        }

        public int hashCode() {
            return Collections.EMPTY_SET.hashCode();
        }

        public boolean equals(Object o) {
            Queryable that;
            return o instanceof Queryable && (that = (Queryable)o).size() == this.size();
        }

        public String toString() {
            return Collections.EMPTY_SET.toString();
        }
    }
}

