/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class DistributionTools {
    public static HashMap KLDistance(Distribution observed, Distribution expected, double logBase) {
        Iterator alpha = ((FiniteAlphabet)observed.getAlphabet()).iterator();
        HashMap<Symbol, Double> kldist = new HashMap<Symbol, Double>(((FiniteAlphabet)observed.getAlphabet()).size());
        while (alpha.hasNext()) {
            Symbol s = (Symbol)alpha.next();
            try {
                double obs = observed.getWeight(s);
                double exp = expected.getWeight(s);
                if (obs == 0.0) {
                    kldist.put(s, new Double(0.0));
                    continue;
                }
                double entropy = obs * Math.log(obs / exp) / Math.log(logBase);
                kldist.put(s, new Double(entropy));
            }
            catch (IllegalSymbolException ise) {
                ise.printStackTrace(System.err);
            }
        }
        return kldist;
    }

    public static HashMap shannonEntropy(Distribution observed, double logBase) {
        Iterator alpha = ((FiniteAlphabet)observed.getAlphabet()).iterator();
        HashMap<Symbol, Double> entropy = new HashMap<Symbol, Double>(((FiniteAlphabet)observed.getAlphabet()).size());
        while (alpha.hasNext()) {
            Symbol s = (Symbol)alpha.next();
            try {
                double obs = observed.getWeight(s);
                if (obs == 0.0) {
                    entropy.put(s, new Double(0.0));
                    continue;
                }
                double e = obs * Math.log(obs) / Math.log(logBase);
                entropy.put(s, new Double(e));
            }
            catch (IllegalSymbolException ise) {
                ise.printStackTrace(System.err);
            }
        }
        return entropy;
    }

    public static double bitsOfInformation(Distribution observed) {
        HashMap ent = DistributionTools.shannonEntropy(observed, 2.0);
        double totalEntropy = 0.0;
        Iterator i = ent.values().iterator();
        while (i.hasNext()) {
            totalEntropy = (Double)i.next();
        }
        return 2.0 - totalEntropy;
    }

    public static Distribution[] distOverAlignment(Alignment a, boolean countGaps) {
        List seqs = a.getLabels();
        Distribution[] pos = new Distribution[a.length()];
        FiniteAlphabet dna = DNATools.getDNA();
        try {
            int i = 0;
            while (i < a.length()) {
                pos[i] = DistributionFactory.DEFAULT.createDistribution(dna);
                SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
                dtc.registerDistribution(pos[i]);
                Iterator j = seqs.iterator();
                while (j.hasNext()) {
                    Object seqLabel = j.next();
                    Symbol s = a.symbolAt(seqLabel, i + 1);
                    if (!countGaps && s.equals(a.getAlphabet().getGapSymbol())) continue;
                    dtc.addCount(pos[i], s, 1.0);
                }
                dtc.train();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return pos;
    }

    /*
     * WARNING - void declaration
     */
    public static Distribution average(Distribution[] dists) {
        Alphabet alpha = dists[0].getAlphabet();
        int i = 1;
        while (i < dists.length) {
            if (!dists[i].getAlphabet().equals(alpha)) {
                throw new IllegalArgumentException("All alphabets must be the same");
            }
            ++i;
        }
        try {
            void iae;
            Distribution average = DistributionFactory.DEFAULT.createDistribution(alpha);
            SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
            dtc.registerDistribution(average);
            int i2 = 0;
            while (i2 < dists.length) {
                Iterator iter = ((FiniteAlphabet)dists[i2].getAlphabet()).iterator();
                while (iter.hasNext()) {
                    Symbol sym = (Symbol)iter.next();
                    dtc.addCount(average, sym, dists[i2].getWeight(sym));
                }
                ++i2;
            }
            dtc.train();
            return iae;
        }
        catch (IllegalAlphabetException iae) {
            throw new NestedError(iae, "Distribution contains an illegal alphabet");
        }
        catch (IllegalSymbolException ise) {
            throw new NestedError(ise, "Distribution contains an illegal symbol");
        }
        catch (ChangeVetoException cve) {
            throw new NestedError(cve, "The Distribution has become locked");
        }
    }
}

