/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class FeatureLabelRenderer
extends AbstractChangeable
implements SequenceRenderer {
    public static final ChangeType LABEL_MAKER = new ChangeType("The label maker has changed", "org.biojava.bio.gui.sequence.FeatureLabelRenderer", "FILL", SequenceRenderContext.LAYOUT);
    private final double depth = 20.0;
    private LabelMaker labelMaker;

    public LabelMaker getLabelMaker() {
        return this.labelMaker;
    }

    public void setLabelMaker(LabelMaker labelMaker) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(LABEL_MAKER);
            ChangeEvent ce = new ChangeEvent(this, LABEL_MAKER, labelMaker, this.labelMaker);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.labelMaker = labelMaker;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.labelMaker = labelMaker;
        }
    }

    public double getDepth(SequenceRenderContext src) {
        List layers = this.bumpLabels(src);
        return (double)layers.size() * 20.0 + 1.0;
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return 0.0;
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        List list = this.bumpLabels(src);
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        int sPos = src.graphicsToSequence(me.getPoint());
        return new SequenceViewerEvent(this, null, sPos, me, path);
    }

    protected List bumpLabels(SequenceRenderContext src) {
        ArrayList lines = new ArrayList();
        Iterator fi = ((FeatureHolder)((Object)src.getSymbols())).filter(new FeatureFilter.OverlapsLocation(src.getRange()), false).features();
        while (fi.hasNext()) {
            Feature f = (Feature)fi.next();
            String label = this.labelMaker.makeLabel(f);
            Location fLoc = null;
            FeatLocLabel featLocLabel = new FeatLocLabel(f, fLoc, label);
            Iterator lineI = lines.iterator();
            List<FeatLocLabel> line = null;
            block1: while (lineI.hasNext()) {
                List curLine = (List)lineI.next();
                Iterator curLineI = curLine.iterator();
                while (curLineI.hasNext()) {
                    Location curLoc = ((FeatLocLabel)curLineI.next()).getLocation();
                    if (curLoc.overlaps(fLoc)) continue block1;
                }
                line = curLine;
                break;
            }
            if (line == null) {
                line = new ArrayList<FeatLocLabel>();
                lines.add(line);
            }
            line.add(featLocLabel);
        }
        return lines;
    }

    public static interface LabelMaker {
        public String makeLabel(Feature var1);
    }

    private static final class FeatLocLabel {
        private final Feature f;
        private final Location location;
        private final String label;

        public final Feature getFeature() {
            return this.f;
        }

        public final Location getLocation() {
            return this.location;
        }

        public final String getLabel() {
            return this.label;
        }

        public FeatLocLabel(Feature f, Location loc, String label) {
            this.f = f;
            this.location = loc;
            this.label = label;
        }

        public String toString() {
            return "feature: " + this.f + " location: " + this.location + " label: " + this.label;
        }
    }
}

