/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.CacheReference;

class DASFeatureSet
implements FeatureHolder {
    private FeatureRequestManager.Ticket featureTicket;
    private CacheReference realFeatures;
    private DASSequence refSequence;
    private URL dataSource;
    private String sourceID;
    private String dataSourceString;

    DASFeatureSet(DASSequence seq, URL ds, String id) throws BioException {
        this.refSequence = seq;
        this.dataSource = ds;
        this.sourceID = id;
        this.dataSourceString = this.dataSource.toString();
    }

    void registerFeatureFetcher() {
        if (this.realFeatures != null && this.realFeatures.get() == null) {
            this.realFeatures = null;
            this.featureTicket = null;
        }
        if (this.featureTicket == null) {
            DASFeatureSetPopulator listener = new DASFeatureSetPopulator();
            FeatureRequestManager frm = this.refSequence.getParentDB().getFeatureRequestManager();
            this.featureTicket = frm.requestFeatures(this.dataSource, this.sourceID, listener);
        }
    }

    protected FeatureHolder getFeatures() {
        FeatureHolder fh;
        if (this.realFeatures != null && (fh = (FeatureHolder)this.realFeatures.get()) != null) {
            return fh;
        }
        try {
            this.registerFeatureFetcher();
            this.featureTicket.doFetch();
        }
        catch (ParseException ex) {
            throw new BioError(ex, "Error parsing feature table");
        }
        catch (BioException ex) {
            throw new BioError(ex);
        }
        if (this.realFeatures == null) {
            throw new BioError("Assertion failure: features didn't get fetched.");
        }
        fh = (FeatureHolder)this.realFeatures.get();
        if (fh == null) {
            throw new BioError("Assertion failure: cache is stupidly small...");
        }
        return fh;
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (FilterUtils.areDisjoint(ff, new FeatureFilter.ByAnnotation("org.biojava.bio.program.das.annotation_server", this.dataSource))) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getFeatures().filter(ff, recurse);
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public Feature createFeature(Feature.Template temp) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on DAS sequences.");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from DAS sequences.");
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    private class DASFeatureSetPopulator
    extends SeqIOAdapter {
        private SimpleFeatureHolder holder;
        private List featureStack = new ArrayList();
        private Feature stackTop = null;

        private DASFeatureSetPopulator() {
        }

        public void startSequence() {
            this.holder = new SimpleFeatureHolder();
        }

        public void endSequence() {
            DASFeatureSet.this.realFeatures = DASFeatureSet.this.refSequence.getParentDB().getFeaturesCache().makeReference(this.holder);
        }

        public void startFeature(Feature.Template temp) throws ParseException {
            if (temp instanceof ComponentFeature.Template) {
                this.featureStack.add(null);
            } else {
                try {
                    Feature f = null;
                    if (temp.annotation == Annotation.EMPTY_ANNOTATION) {
                        temp.annotation = new SmallAnnotation();
                    } else if (temp.annotation.containsProperty("org.biojava.bio.program.xff.id")) {
                        temp.annotation.setProperty("org.biojava.bio.program.das.feature_id", temp.annotation.getProperty("org.biojava.bio.program.xff.id"));
                    }
                    temp.annotation.setProperty("org.biojava.bio.program.das.annotation_server", DASFeatureSet.this.dataSource);
                    if (this.stackTop == null) {
                        f = DASFeatureSet.this.refSequence.realizeFeature(DASFeatureSet.this.refSequence, temp);
                        this.holder.addFeature(f);
                    } else {
                        f = this.stackTop.createFeature(temp);
                    }
                    this.featureStack.add(f);
                    this.stackTop = f;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ParseException(ex, "Couldn't realize feature in DAS");
                }
            }
        }

        public void addFeatureProperty(Object key, Object value) throws ParseException {
            if (this.stackTop == null) {
                return;
            }
            try {
                if (key.equals("org.biojava.bio.program.xff.id")) {
                    this.stackTop.getAnnotation().setProperty("org.biojava.bio.program.das.feature_id", value);
                } else {
                    Annotation ann = this.stackTop.getAnnotation();
                    if (ann.containsProperty(key)) {
                        ArrayList<Object> col;
                        Object o = ann.getProperty(key);
                        if (o instanceof Collection) {
                            col = (ArrayList<Object>)o;
                        } else {
                            col = new ArrayList<Object>();
                            col.add(o);
                            ann.setProperty(key, col);
                        }
                        col.add(value);
                    } else {
                        this.stackTop.getAnnotation().setProperty(key, value);
                    }
                }
            }
            catch (ChangeVetoException ex) {
                throw new ParseException(ex, "Couldn't set feature property");
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }

        public void endFeature() throws ParseException {
            if (this.featureStack.size() < 1) {
                throw new BioError("Missmatched endFeature()");
            }
            this.featureStack.remove(this.featureStack.size() - 1);
            int pos = this.featureStack.size() - 1;
            this.stackTop = null;
            while (this.stackTop == null && pos >= 0) {
                this.stackTop = (Feature)this.featureStack.get(pos--);
            }
        }
    }
}

