/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DASGFFParser {
    private Map ticketsByID;
    private List doneTickets = new ArrayList();
    private int seqStart;
    private int seqStop;

    DASGFFParser(Map ticketsByID) {
        this.ticketsByID = ticketsByID;
    }

    List getDoneTickets() {
        return this.doneTickets;
    }

    void parseStream(InputStream data) throws BioException, ParseException, IOException, SAXException {
        InputSource is = new InputSource(data);
        DocumentBuilder parser = DASSequence.nonvalidatingParser();
        Element el = parser.parse(is).getDocumentElement();
        NodeList gffl = el.getElementsByTagName("GFF");
        if (gffl.getLength() != 1) {
            throw new BioException("Couldn't find GFF element");
        }
        el = (Element)gffl.item(0);
        String version = el.getAttribute("version");
        if (version != null) {
            try {
                double v = Double.parseDouble(version);
                if (v < 0.95 || v > 1.0) {
                    throw new ParseException("Unrecognized DASGFF version " + version);
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException(ex);
            }
        }
        Node n = el.getFirstChild();
        while (n != null) {
            if (n instanceof Element) {
                FeatureRequestManager.Ticket t;
                String segID;
                Element echld = (Element)n;
                String tagName = echld.getTagName();
                if (tagName.equals("SEGMENT")) {
                    segID = echld.getAttribute("id");
                    t = (FeatureRequestManager.Ticket)this.ticketsByID.get(segID);
                    if (t == null) {
                        throw new SAXException("Response segment " + segID + " wasn't requested");
                    }
                    this.parseSegment(echld, t.getOutputListener());
                    t.setAsFetched();
                    this.doneTickets.add(t);
                } else if (tagName.equals("segmentNotAnnotated")) {
                    segID = echld.getAttribute("id");
                    t = (FeatureRequestManager.Ticket)this.ticketsByID.get(segID);
                    if (t == null) {
                        throw new SAXException("Response segment " + segID + " wasn't requested");
                    }
                    SeqIOListener siol = t.getOutputListener();
                    siol.startSequence();
                    siol.endSequence();
                    t.setAsFetched();
                    this.doneTickets.add(t);
                } else if (tagName.equals("segmentError")) {
                    segID = echld.getAttribute("id");
                    String segError = echld.getAttribute("error");
                    throw new ParseException("Error " + segError + " fetching " + segID);
                }
            }
            n = n.getNextSibling();
        }
    }

    private void parseSegment(Element el, SeqIOListener siol) throws BioException, ParseException {
        String segVersion;
        String segStop;
        siol.startSequence();
        String segStart = el.getAttribute("start");
        if (segStart != null) {
            try {
                this.seqStart = Integer.parseInt(segStart);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            siol.addSequenceProperty("sequence.start", segStart);
        }
        if ((segStop = el.getAttribute("stop")) != null) {
            try {
                this.seqStop = Integer.parseInt(segStop);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            siol.addSequenceProperty("sequence.stop", segStop);
        }
        if ((segVersion = el.getAttribute("version")) != null) {
            siol.addSequenceProperty("sequence.version", segVersion);
        }
        Node segChld = el.getFirstChild();
        while (segChld != null) {
            Feature.Template temp;
            Element featureEl;
            if (segChld instanceof Element && (featureEl = (Element)segChld).getTagName().equals("FEATURE") && (temp = this.parseDASFeature(featureEl)) != null) {
                siol.startFeature(temp);
                siol.endFeature();
            }
            segChld = segChld.getNextSibling();
        }
        siol.endSequence();
    }

    private Feature.Template parseDASFeature(Element fe) throws NumberFormatException, ParseException {
        String f_id = null;
        String f_label = null;
        String type = "unknown";
        String method = "unknown";
        int start = -1;
        int end = -1;
        String orientation = "0";
        String phase = "-";
        Object loc = null;
        boolean isReferenceFeature = false;
        String category = null;
        String refName = null;
        int refStart = -1;
        int refStop = -1;
        f_id = fe.getAttribute("id");
        f_label = fe.getAttribute("label");
        Node n = fe.getFirstChild();
        while (n != null) {
            if (n instanceof Element) {
                Element nel = (Element)n;
                String tag = nel.getTagName();
                if (tag.equals("TYPE")) {
                    type = this.getChildText(nel);
                    String reference = nel.getAttribute("reference");
                    if ("yes".equals(reference)) {
                        isReferenceFeature = true;
                    }
                    category = nel.getAttribute("category");
                } else if (tag.equals("METHOD")) {
                    method = this.getChildText(nel);
                } else if (tag.equals("START")) {
                    start = Integer.parseInt(this.getChildText(nel));
                } else if (tag.equals("END")) {
                    end = Integer.parseInt(this.getChildText(nel));
                } else if (tag.equals("ORIENTATION")) {
                    orientation = this.getChildText(nel);
                } else if (tag.equals("PHASE")) {
                    phase = this.getChildText(nel);
                } else if (tag.equals("GROUP")) {
                    Node gn = nel.getFirstChild();
                    while (gn != null) {
                        Element gel;
                        String gtag;
                        if (gn instanceof Element && (gtag = (gel = (Element)gn).getTagName()).equals("TARGET")) {
                            String refStopS;
                            refName = gel.getAttribute("ref");
                            String refStartS = gel.getAttribute("start");
                            if (refStartS.length() > 0) {
                                refStart = Integer.parseInt(refStartS);
                            }
                            if ((refStopS = gel.getAttribute("stop")).length() > 0) {
                                refStop = Integer.parseInt(refStopS);
                            }
                        }
                        gn = gn.getNextSibling();
                    }
                }
            }
            n = n.getNextSibling();
        }
        Feature.Template temp = null;
        if (isReferenceFeature && category.equals("component")) {
            if (refName == null) {
                throw new ParseException("Can't template componentFeature without a specified TARGET");
            }
            if (start < this.seqStart || start > this.seqStop || end < this.seqStart || end > this.seqStop || refStop == 0) {
                return null;
            }
            ComponentFeature.Template ctemp = new ComponentFeature.Template();
            ctemp.componentLocation = new RangeLocation(refStart, refStop);
            ctemp.strand = orientation.equals("+") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
            ctemp.annotation = new SmallAnnotation();
            try {
                ctemp.annotation.setProperty("sequence.id", refName);
            }
            catch (ChangeVetoException ex) {
                throw new BioError(ex);
            }
            temp = ctemp;
        } else if (orientation.equals("+") || orientation.equals("-")) {
            StrandedFeature.Template stemp = new StrandedFeature.Template();
            stemp.strand = orientation.equals("+") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
            temp = stemp;
        } else {
            temp = new Feature.Template();
        }
        temp.type = type;
        temp.source = method;
        temp.location = loc == null ? new RangeLocation(start, end) : loc;
        if (temp.annotation == null) {
            temp.annotation = new SmallAnnotation();
        }
        try {
            if (f_id.length() > 0) {
                temp.annotation.setProperty("org.biojava.bio.program.das.feature_id", f_id);
            }
            if (f_label.length() > 0) {
                temp.annotation.setProperty("org.biojava.bio.program.das.feature_label", f_label);
            }
        }
        catch (ChangeVetoException ex) {
            throw new BioError(ex);
        }
        return temp;
    }

    private String getChildText(Element el) {
        StringBuffer sb = new StringBuffer();
        Node n = el.getFirstChild();
        while (n != null) {
            if (n instanceof Text) {
                sb.append(((Text)n).getData());
            }
            n = n.getNextSibling();
        }
        return sb.toString().trim();
    }
}

