/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.BlastSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BlastLikeSAXParser
extends AbstractNativeAppSAXParser {
    private BlastLikeVersionSupport oVersion = new BlastLikeVersionSupport();
    private BlastSAXParser oBlast;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private boolean tValidFormat = false;
    private static final int STARTUP = 0;
    private static final int INSIDE_FILE = 1;

    public BlastLikeSAXParser() {
        this.changeState(0);
        this.setNamespacePrefix("biojava");
        this.addPrefixMapping("biojava", "http://www.biojava.org");
    }

    public void parse(InputSource poSource) throws IOException, SAXException {
        BufferedReader oContents = this.getContentStream(poSource);
        this.getContentHandler().startDocument();
        try {
            String oLine = oContents.readLine();
            while (oLine != null) {
                this.interpret(oContents, oLine);
                oLine = oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interrupted");
        }
        oContents.close();
        if (!this.tValidFormat) {
            throw new SAXException("Could not recognise the format of this file as one supported by the framework.");
        }
        this.endElement(new QName(this, this.prefix("BlastLikeDataSetCollection")));
    }

    public void setModeStrict() {
        this.oVersion.setMode(0);
    }

    public void setModeLazy() {
        this.oVersion.setMode(1);
    }

    private void interpret(BufferedReader poContents, String poLine) throws SAXException {
        if (this.iState == 0 && this.oVersion.isStartOfDataSet(poLine)) {
            if (this.oVersion.getProgram() == 31) {
                try {
                    poLine = poContents.readLine();
                }
                catch (IOException x) {
                    System.out.println(x.getMessage());
                    System.out.println("File read interrupted");
                    throw new SAXException("Error parsing GCG File");
                }
            }
            this.tValidFormat = this.oVersion.assignProgramAndVersion(poLine);
            if (!this.oVersion.isSupported()) {
                throw new SAXException("Program " + this.oVersion.getProgramString() + " Version " + this.oVersion.getVersionString() + " is not supported by the biojava blast-like " + "parsing framework");
            }
            this.oAtts.clear();
            this.oAttQName.setQName("xmlns");
            if (!this.oAttQName.getLocalName().equals("")) {
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "");
            }
            this.oAttQName.setQName("xmlns:biojava");
            if (!this.oAttQName.getLocalName().equals("")) {
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "http://www.biojava.org");
            }
            this.startElement(new QName(this, this.prefix("BlastLikeDataSetCollection")), this.oAtts);
            this.onNewDataSet(poContents, poLine);
            return;
        }
        if (this.iState == 1 && this.oVersion.isStartOfDataSet(poLine)) {
            this.tValidFormat = this.oVersion.assignProgramAndVersion(poLine);
            this.onNewDataSet(poContents, poLine);
            return;
        }
    }

    private void onNewDataSet(BufferedReader poContents, String poLine) throws SAXException {
        this.oBlast = new BlastSAXParser(this.oVersion, this.getNamespacePrefix());
        this.oBlast.setContentHandler(this.oHandler);
        String oLine = this.oBlast.parse(poContents, poLine);
        this.changeState(1);
        if (oLine == null) {
            return;
        }
        this.interpret(poContents, oLine);
    }
}

