/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.program.ssbind.SSPropHandlerFactory;
import org.biojava.bio.program.ssbind.SeqSimilarityAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BlastDBQueryHandler
extends DefaultHandler {
    public static final SSPropHandlerFactory BLAST_DBQUERY_HANDLER_FACTORY = new SSPropHandlerFactory(){

        public ContentHandler getHandler(SeqSimilarityAdapter context) {
            return new BlastDBQueryHandler(context);
        }
    };
    private SeqSimilarityAdapter context;
    private StringBuffer data;
    private int level = 0;

    BlastDBQueryHandler(SeqSimilarityAdapter context) {
        this.context = context;
        this.data = new StringBuffer();
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        ++this.level;
        if (this.level > 1) {
            throw new SAXException("Found child element when expecting character data");
        }
    }

    public void endElement(String nsURI, String localName, String qName) throws SAXException {
        --this.level;
        if (this.level == 0) {
            this.setStringValue(this.data.toString());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.data.append(ch, start, length);
    }

    private void setStringValue(String s) throws SAXException {
        String program = this.context.getProgram().toUpperCase();
        if (program.indexOf("BLAST") == -1) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s.trim());
        String query = null;
        String database = null;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("Query=")) {
                query = st.nextToken();
                continue;
            }
            if (!t.equals("Database:")) continue;
            database = st.nextToken();
            break;
        }
        if (query == null) {
            throw new SAXException("Failed to parse query sequence ID");
        }
        if (database == null) {
            throw new SAXException("Failed to parse database ID");
        }
        try {
            this.context.scHandler.setQuerySeq(query);
        }
        catch (BioException be) {
            throw new SAXException("Received a query sequence ID which fails: " + be.getMessage());
        }
        try {
            this.context.scHandler.setSubjectDB(database);
        }
        catch (BioException be) {
            throw new SAXException("Received a database ID which fails: " + be.getMessage());
        }
    }
}

