/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import org.biojava.bio.search.SeqSimilaritySearchSubHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Alignment;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SimpleSeqSimilaritySearchSubHit
implements SeqSimilaritySearchSubHit,
Cloneable {
    private double score;
    private double pValue;
    private double eValue;
    private int queryStart;
    private int queryEnd;
    private StrandedFeature.Strand queryStrand;
    private int subjectStart;
    private int subjectEnd;
    private StrandedFeature.Strand subjectStrand;
    private Alignment alignment;

    public SimpleSeqSimilaritySearchSubHit(double score, double eValue, double pValue, int queryStart, int queryEnd, StrandedFeature.Strand queryStrand, int subjectStart, int subjectEnd, StrandedFeature.Strand subjectStrand, Alignment alignment) {
        Contract.pre(!Double.isNaN(score), "score was NaN");
        Contract.pre(queryStrand != null, "queryStrand was null");
        Contract.pre(subjectStrand != null, "subjectStrand was null");
        Contract.pre(alignment != null, "alignment was null");
        this.score = score;
        this.pValue = pValue;
        this.eValue = eValue;
        this.queryStart = queryStart;
        this.queryEnd = queryEnd;
        this.queryStrand = queryStrand;
        this.subjectStart = subjectStart;
        this.subjectEnd = subjectEnd;
        this.subjectStrand = subjectStrand;
        this.alignment = alignment;
    }

    public double getScore() {
        return this.score;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    public StrandedFeature.Strand getQueryStrand() {
        return this.queryStrand;
    }

    public int getSubjectStart() {
        return this.subjectStart;
    }

    public int getSubjectEnd() {
        return this.subjectEnd;
    }

    public StrandedFeature.Strand getSubjectStrand() {
        return this.subjectStrand;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public String toString() {
        return "SimpleSeqSimilaritySearchSubHit with score " + this.getScore();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchSubHit that = (SimpleSeqSimilaritySearchSubHit)o;
        if (!ObjectUtil.equals(this.score, that.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, that.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, that.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryStart, that.queryStart)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryEnd, that.queryEnd)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryStrand, that.queryStrand)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectStart, that.subjectStart)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectEnd, that.subjectEnd)) {
            return false;
        }
        return ObjectUtil.equals(this.subjectStrand, that.subjectStrand);
    }

    public int hashCode() {
        int hc = 0;
        hc = ObjectUtil.hashCode(hc, this.score);
        hc = ObjectUtil.hashCode(hc, this.pValue);
        hc = ObjectUtil.hashCode(hc, this.eValue);
        hc = ObjectUtil.hashCode(hc, this.queryStart);
        hc = ObjectUtil.hashCode(hc, this.queryEnd);
        hc = ObjectUtil.hashCode(hc, this.queryStrand);
        hc = ObjectUtil.hashCode(hc, this.subjectStart);
        hc = ObjectUtil.hashCode(hc, this.subjectEnd);
        hc = ObjectUtil.hashCode(hc, this.subjectStrand);
        return hc;
    }

    public Object clone() {
        return this;
    }
}

