/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SubSequence
implements Sequence {
    private Sequence parent;
    private SymbolList symbols;
    private FeatureHolder features;
    private String name;
    private String uri;
    private Annotation annotation;
    protected transient ChangeSupport changeSupport;
    private transient ChangeListener forwarder;

    public SubSequence(Sequence seq, int start, int end) {
        this.parent = seq;
        this.symbols = seq.subList(start, end);
        FeatureFilter.OverlapsLocation overlapping = new FeatureFilter.OverlapsLocation(new RangeLocation(start, end));
        this.features = new ProjectedFeatureHolder(seq, overlapping, this, 1 - start, false);
        this.name = seq.getName() + " (" + start + " - " + end + ")";
        this.uri = seq.getURN() + "?start=" + start + ";end=" + end;
        this.annotation = seq.getAnnotation();
    }

    public Symbol symbolAt(int pos) {
        return this.symbols.symbolAt(pos);
    }

    public Alphabet getAlphabet() {
        return this.symbols.getAlphabet();
    }

    public SymbolList subList(int start, int end) {
        return this.symbols.subList(start, end);
    }

    public String seqString() {
        return this.symbols.seqString();
    }

    public String subStr(int start, int end) {
        return this.symbols.subStr(start, end);
    }

    public List toList() {
        return this.symbols.toList();
    }

    public int length() {
        return this.symbols.length();
    }

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit SubSequences");
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public Iterator features() {
        return this.features.features();
    }

    public boolean containsFeature(Feature f) {
        return this.features.containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.features.filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template templ) throws ChangeVetoException {
        throw new ChangeVetoException("Can't add features to subsequences");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from subsequences");
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.uri;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    protected void allocChangeSupport() {
        this.changeSupport = new ChangeSupport();
        this.forwarder = new ChangeListener(){

            public void preChange(ChangeEvent ev) throws ChangeVetoException {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePreChangeEvent(new ChangeEvent(this, ev.getType(), ev.getChange(), ev.getPrevious(), ev));
                }
            }

            public void postChange(ChangeEvent ev) {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePostChangeEvent(new ChangeEvent(this, ev.getType(), ev.getChange(), ev.getPrevious(), ev));
                }
            }
        };
        this.symbols.addChangeListener(this.forwarder);
        this.features.addChangeListener(this.forwarder);
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeSupport == null) {
            this.allocChangeSupport();
        }
        this.changeSupport.addChangeListener(cl);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.allocChangeSupport();
        }
        this.changeSupport.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(cl, ct);
        }
    }

    public Sequence getParent() {
        return this.parent;
    }
}

