/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.genomic.TranslatedRegion;
import org.biojava.bio.seq.impl.SimpleFeature;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;

public class SimpleTranslatedRegion
extends SimpleFeature
implements TranslatedRegion {
    protected Sequence translation;

    public Sequence getTranslation() {
        if (this.translation == null) {
            SymbolList asProtein;
            SimpleSequenceFactory sf = new SimpleSequenceFactory();
            try {
                asProtein = RNATools.translate(this.getSymbols());
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError(iae, "Assertion Failure: Could not translate RNA into Protein");
            }
            this.translation = sf.createSequence(asProtein, this.getSequence().getURN() + "/" + this.getType() + "/" + this.getLocation(), this.getType() + "/" + this.getLocation(), Annotation.EMPTY_ANNOTATION);
        }
        return this.translation;
    }

    public SimpleTranslatedRegion(Sequence sourceSeq, FeatureHolder parent, TranslatedRegion.Template template) {
        super(sourceSeq, parent, template);
        this.translation = template.translation;
    }

    public Feature.Template makeTemplate() {
        TranslatedRegion.Template trt = new TranslatedRegion.Template();
        this.fillTemplate(trt);
        return trt;
    }

    protected void fillTempalte(TranslatedRegion.Template ft) {
        super.fillTemplate(ft);
        ft.translation = this.getTranslation();
    }
}

