/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.StrandedLocation;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.FuzzyPointLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

class EmblLikeLocationParser {
    private String location;
    private LocationLexer lexer;
    private int nextCharIndex;
    private Object thisToken;
    private List instructStack = new ArrayList();
    private List subLocations = new ArrayList();
    private List startCoords = new ArrayList();
    private List endCoords = new ArrayList();
    private boolean isPointLoc = true;
    private boolean fuzzyCoord = false;
    private boolean unboundMin = false;
    private boolean unboundMax = false;
    private boolean isBetweenLocation = false;
    private StrandedFeature.Strand mStrandType = StrandedFeature.POSITIVE;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;

    EmblLikeLocationParser() {
        this.lexer = new LocationLexer();
    }

    StrandedLocation parseLocation(String location) throws BioException {
        this.location = location;
        if (this.countChar(location, '(') != this.countChar(location, ')')) {
            throw new BioException("Unbalanced parentheses in location: " + location);
        }
        this.nextCharIndex = 0;
        this.instructStack.clear();
        this.subLocations.clear();
        this.thisToken = this.lexer.getNextToken();
        while (this.thisToken != null) {
            if ((class$java$lang$String == null ? EmblLikeLocationParser.class$("java.lang.String") : class$java$lang$String).isInstance(this.thisToken)) {
                String toke = (String)this.thisToken;
                if (toke.equals("..")) {
                    this.isPointLoc = false;
                } else {
                    this.instructStack.add(this.thisToken);
                }
            } else if ((class$java$lang$Integer == null ? EmblLikeLocationParser.class$("java.lang.Integer") : class$java$lang$Integer).isInstance(this.thisToken)) {
                if (this.isPointLoc) {
                    this.startCoords.add(this.thisToken);
                } else {
                    this.endCoords.add(this.thisToken);
                }
            } else if ((class$java$lang$Character == null ? EmblLikeLocationParser.class$("java.lang.Character") : class$java$lang$Character).isInstance(this.thisToken)) {
                char toke = ((Character)this.thisToken).charValue();
                switch (toke) {
                    case '(': 
                    case ':': {
                        break;
                    }
                    case '^': {
                        this.isBetweenLocation = true;
                    }
                    case '<': {
                        this.unboundMin = true;
                        break;
                    }
                    case '>': {
                        this.unboundMax = true;
                        break;
                    }
                    case '.': {
                        this.fuzzyCoord = true;
                        break;
                    }
                    case ',': {
                        this.processCoords();
                        break;
                    }
                    case ')': {
                        if (this.fuzzyCoord) {
                            this.fuzzyCoord = false;
                            break;
                        }
                        this.processCoords();
                        this.processInstructs();
                        break;
                    }
                    default: {
                        throw new BioException("Unknown character '" + toke + "' within location: " + location);
                    }
                }
            }
            this.thisToken = this.lexer.getNextToken();
        }
        this.processCoords();
        StrandedLocation returnLocation = this.subLocations.size() == 1 ? new StrandedLocation((Location)this.subLocations.get(0), this.mStrandType) : new StrandedLocation(LocationTools.union(this.subLocations), this.mStrandType);
        return returnLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCoords() throws BioException {
        if (this.startCoords.isEmpty() && this.endCoords.isEmpty()) {
            return;
        }
        if (this.isBetweenLocation) {
            int minCoord = (Integer)this.startCoords.get(0);
            int maxCoord = (Integer)this.startCoords.get(1);
            this.subLocations.add(new BetweenLocation(new RangeLocation(minCoord, maxCoord)));
        } else if (this.startCoords.size() == 1 && this.endCoords.isEmpty()) {
            int outerMin;
            int innerMin;
            int outerMax;
            int innerMax = outerMax = (innerMin = (outerMin = ((Integer)this.startCoords.get(0)).intValue()));
            if (this.unboundMin || this.unboundMax) {
                this.subLocations.add(new FuzzyPointLocation(this.unboundMin ? Integer.MIN_VALUE : innerMin, this.unboundMax ? Integer.MAX_VALUE : innerMax, FuzzyPointLocation.RESOLVE_AVERAGE));
            } else {
                if (!this.isPointLoc) throw new BioException("Internal error in location parsing; parser became confused: " + this.location);
                this.subLocations.add(new PointLocation(innerMin));
            }
        } else if (this.startCoords.size() == 2 && this.endCoords.isEmpty()) {
            int outerMax;
            int outerMin;
            int innerMin = outerMin = ((Integer)this.startCoords.get(0)).intValue();
            int innerMax = outerMax = ((Integer)this.startCoords.get(1)).intValue();
            this.subLocations.add(new FuzzyPointLocation(innerMin, innerMax, FuzzyPointLocation.RESOLVE_AVERAGE));
        } else if (this.startCoords.size() == 1 && this.endCoords.size() == 1) {
            int outerMax;
            int outerMin;
            int innerMin = outerMin = ((Integer)this.startCoords.get(0)).intValue();
            int innerMax = outerMax = ((Integer)this.endCoords.get(0)).intValue();
            if (this.unboundMin || this.unboundMax) {
                this.subLocations.add(new FuzzyLocation(this.unboundMin ? Integer.MIN_VALUE : outerMin, this.unboundMax ? Integer.MAX_VALUE : outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER));
            } else {
                try {
                    this.subLocations.add(new RangeLocation(outerMin, outerMax));
                }
                catch (IndexOutOfBoundsException ioe) {
                    throw new BioException(ioe);
                }
            }
        } else if (this.startCoords.size() == 2 && this.endCoords.size() == 1) {
            int outerMax;
            int outerMin = (Integer)this.startCoords.get(0);
            int innerMin = (Integer)this.startCoords.get(1);
            int innerMax = outerMax = ((Integer)this.endCoords.get(0)).intValue();
            this.subLocations.add(new FuzzyLocation(outerMin, outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER));
        } else if (this.startCoords.size() == 1 && this.endCoords.size() == 2) {
            int innerMin;
            int outerMin = innerMin = ((Integer)this.startCoords.get(0)).intValue();
            int innerMax = (Integer)this.endCoords.get(0);
            int outerMax = (Integer)this.endCoords.get(1);
            this.subLocations.add(new FuzzyLocation(outerMin, outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER));
        } else {
            if (this.startCoords.size() != 2 || this.endCoords.size() != 2) throw new BioException("Internal error in location parsing; parser became confused; " + this.location);
            int outerMin = (Integer)this.startCoords.get(0);
            int innerMin = (Integer)this.startCoords.get(1);
            int innerMax = (Integer)this.endCoords.get(0);
            int outerMax = (Integer)this.endCoords.get(1);
            this.subLocations.add(new FuzzyLocation(outerMin, outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER));
        }
        this.startCoords.clear();
        this.endCoords.clear();
        this.isPointLoc = true;
        this.unboundMin = false;
        this.unboundMax = false;
        this.fuzzyCoord = false;
        this.isBetweenLocation = false;
        this.mStrandType = StrandedFeature.POSITIVE;
    }

    private void processInstructs() throws BioException {
        String instruct = (String)this.instructStack.remove(this.instructStack.size() - 1);
        if (!instruct.equals("join") && !instruct.equals("order")) {
            if (instruct.equals("complement")) {
                this.mStrandType = StrandedFeature.NEGATIVE;
            } else {
                throw new BioException("Remote locations are not supported: " + this.location);
            }
        }
    }

    private int countChar(String s, char c) {
        int cnt = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == c) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LocationLexer {
        private LocationLexer() {
        }

        Object getNextToken() {
            char thisChar;
            block6: while (true) {
                if (EmblLikeLocationParser.this.nextCharIndex == EmblLikeLocationParser.this.location.length()) {
                    return null;
                }
                thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
                switch (thisChar) {
                    case '\t': 
                    case ' ': {
                        continue block6;
                    }
                    case '(': 
                    case ')': 
                    case ',': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '^': {
                        EmblLikeLocationParser.this.nextCharIndex++;
                        return new Character(thisChar);
                    }
                    case '.': {
                        if (EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex + 1) == '.') {
                            EmblLikeLocationParser.this.nextCharIndex += 2;
                            return "..";
                        }
                        EmblLikeLocationParser.this.nextCharIndex++;
                        return new Character('.');
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return this.followInteger();
                    }
                }
                break;
            }
            String text = this.followText();
            if (text.equals("")) {
                EmblLikeLocationParser.this.nextCharIndex++;
                return new String("" + thisChar);
            }
            return text;
        }

        private Integer followInteger() {
            StringBuffer intString = new StringBuffer();
            char thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
            while (Character.isDigit(thisChar)) {
                intString.append(thisChar);
                EmblLikeLocationParser.this.nextCharIndex++;
                if (EmblLikeLocationParser.this.nextCharIndex >= EmblLikeLocationParser.this.location.length()) break;
                thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
            }
            return new Integer(intString.toString());
        }

        /*
         * Unable to fully structure code
         */
        private String followText() {
            textString = new StringBuffer("");
            thisChar = EmblLikeLocationParser.access$200(EmblLikeLocationParser.this).charAt(EmblLikeLocationParser.access$100(EmblLikeLocationParser.this));
            if (Character.isLetter(thisChar)) ** GOTO lbl11
            return "";
lbl-1000:
            // 1 sources

            {
                textString.append(thisChar);
                EmblLikeLocationParser.access$108(EmblLikeLocationParser.this);
                if (EmblLikeLocationParser.access$100(EmblLikeLocationParser.this) >= EmblLikeLocationParser.access$200(EmblLikeLocationParser.this).length()) break;
                thisChar = EmblLikeLocationParser.access$200(EmblLikeLocationParser.this).charAt(EmblLikeLocationParser.access$100(EmblLikeLocationParser.this));
lbl11:
                // 2 sources

                ** while (Character.isLetterOrDigit((char)thisChar) || thisChar == '.')
            }
lbl12:
            // 2 sources

            return textString.toString();
        }
    }
}

