/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class IntegerParser
implements SymbolParser,
Serializable {
    private IntegerAlphabet alpha = IntegerAlphabet.getInstance();

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public Symbol parseToken(String seq) throws IllegalSymbolException {
        int i = Integer.parseInt(seq);
        return this.alpha.getSymbol(i);
    }

    public SymbolList parse(String seq) throws IllegalSymbolException {
        StringTokenizer st = new StringTokenizer(seq);
        int[] ints = new int[st.countTokens()];
        int x = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                int i;
                ints[x] = i = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalSymbolException(nfe, token + " is not a legal integer");
            }
            ++x;
        }
        SymbolList sl = IntegerAlphabet.fromArray(ints);
        return sl;
    }

    public StreamParser parseStream(SeqIOListener listener) {
        return new IPStreamParser(listener);
    }

    Symbol parseCharToken(char token) {
        int i = Character.getNumericValue(token);
        return this.alpha.getSymbol(i);
    }

    private class IPStreamParser
    implements StreamParser {
        private SeqIOListener listener;
        private Symbol[] buffer;

        public IPStreamParser(SeqIOListener l) {
            this.listener = l;
        }

        public void characters(char[] data, int start, int len) throws IllegalSymbolException {
            String s = new String(data);
            String ss = s.substring(start, start + len);
            SymbolList sl = IntegerParser.this.parse(ss);
            this.buffer = new Symbol[sl.length()];
            int i = 0;
            while (i < this.buffer.length) {
                this.buffer[i] = sl.symbolAt(i + 1);
                ++i;
            }
            try {
                this.listener.addSymbols(IntegerParser.this.getAlphabet(), this.buffer, 0, this.buffer.length);
            }
            catch (IllegalAlphabetException ex) {
                throw new BioError(ex, "Assertion failed: can't add symbols.");
            }
        }

        public void close() {
        }
    }
}

