/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.bio.seq.io.SwissprotFeatureTableParser;

public class SwissprotProcessor
extends SequenceBuilderFilter {
    public static final String PROPERTY_SWISSPROT_ACCESSIONS = "swissprot.accessions";
    public static final String PROPERTY_SWISSPROT_COMMENT = "swissprot.comment";
    public static final String PROPERTY_SWISSPROT_FEATUREATTRIBUTE = "swissprot.featureattribute";
    private boolean mBadFeature = false;
    private SwissprotFeatureTableParser features;
    private static HashSet featureKeys = null;
    private List accessions = new ArrayList();

    public SwissprotProcessor(SequenceBuilder delegate) {
        super(delegate);
        this.features = new SwissprotFeatureTableParser(this, "SWISSPROT");
    }

    public void endSequence() throws ParseException {
        if (this.accessions.size() > 0) {
            String id = (String)this.accessions.get(0);
            this.getDelegate().setName(id);
            this.getDelegate().setURI("urn:sequence/swissprot:" + id);
            this.getDelegate().addSequenceProperty(PROPERTY_SWISSPROT_ACCESSIONS, this.accessions);
            this.accessions = new ArrayList();
        }
        this.getDelegate().endSequence();
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        try {
            if (this.mBadFeature) {
                String featureLine = value.toString();
                if (key.equals("FT") && featureLine.charAt(0) != ' ') {
                    this.mBadFeature = false;
                    this.features.startFeature(featureLine.substring(0, 8).trim());
                    this.features.featureData(featureLine.substring(9));
                }
            } else {
                if (this.features.inFeature() && !key.equals("FT")) {
                    this.features.endFeature();
                }
                if (key.equals("FT")) {
                    String featureLine = value.toString();
                    if (featureLine.charAt(0) != ' ') {
                        if (this.features.inFeature()) {
                            this.features.endFeature();
                        }
                        this.features.startFeature(featureLine.substring(0, 8).trim());
                    }
                    this.features.featureData(featureLine.substring(9));
                } else {
                    this.getDelegate().addSequenceProperty(key, value);
                    if (key.equals("AC")) {
                        String acc = value.toString();
                        StringTokenizer toke = new StringTokenizer(acc, "; ");
                        while (toke.hasMoreTokens()) {
                            this.accessions.add(toke.nextToken());
                        }
                    }
                }
            }
        }
        catch (BioException ex) {
            this.mBadFeature = true;
            System.err.println(ex);
        }
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;

        public Factory(SequenceBuilderFactory delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new SwissprotProcessor(this.delegateFactory.makeSequenceBuilder());
        }
    }
}

