/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.io.NameParser;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;

public class AllTokensAlphabet
extends AbstractAlphabet
implements Serializable {
    private Map tokenToSymbol;
    private Map nameToSymbol;
    private Set symbols;
    private String name;
    private Annotation annotation;

    protected void addSymbolImpl(AtomicSymbol s) {
        this.symbols.add(s);
        Character token = new Character(s.getToken());
        if (!this.tokenToSymbol.keySet().contains(token)) {
            this.tokenToSymbol.put(token, s);
        }
        this.nameToSymbol.put(s.getName(), s);
    }

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    protected boolean containsImpl(AtomicSymbol s) {
        return this.symbols.contains(s);
    }

    public String getName() {
        return this.name;
    }

    public List getAlphabets() {
        return new SingletonList(this);
    }

    public SymbolParser getParser(String name) throws NoSuchElementException {
        if (name.equals("name")) {
            return new NameParser(this.nameToSymbol){

                public Symbol parseToken(String token) throws IllegalSymbolException {
                    Symbol sym = (Symbol)AllTokensAlphabet.this.nameToSymbol.get(token);
                    if (sym == null) {
                        sym = AlphabetManager.createSymbol(token.charAt(0), token, null);
                        try {
                            AllTokensAlphabet.this.addSymbol(sym);
                        }
                        catch (ChangeVetoException cve) {
                            throw new IllegalSymbolException(cve, "Couldn't parse '" + token + "'");
                        }
                    }
                    return sym;
                }
            };
        }
        if (name.equals("token")) {
            return new SymbolParser(){

                public Alphabet getAlphabet() {
                    return AllTokensAlphabet.this;
                }

                public SymbolList parse(String seq) throws IllegalSymbolException {
                    ArrayList<Symbol> symList = new ArrayList<Symbol>(seq.length());
                    int i = 0;
                    while (i < seq.length()) {
                        symList.add(this.parseToken(seq.substring(i, i + 1)));
                        ++i;
                    }
                    try {
                        return new SimpleSymbolList(this.getAlphabet(), symList);
                    }
                    catch (IllegalSymbolException ex) {
                        throw new BioError(ex);
                    }
                }

                public Symbol parseToken(String token) throws IllegalSymbolException {
                    char c = token.charAt(0);
                    Character ch = new Character(c);
                    Symbol s = (Symbol)AllTokensAlphabet.this.tokenToSymbol.get(ch);
                    if (s == null) {
                        s = AlphabetManager.createSymbol(c, token, null);
                        try {
                            AllTokensAlphabet.this.addSymbol(s);
                        }
                        catch (ChangeVetoException cve) {
                            throw new IllegalSymbolException(cve, "Can't add symbol '" + token + "'");
                        }
                    }
                    return s;
                }

                public StreamParser parseStream(SeqIOListener l) {
                    SeqIOListener listener = l;
                    return new StreamParser(this, listener){
                        private final /* synthetic */ SeqIOListener val$listener;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$listener = val$listener;
                        }

                        public void characters(char[] data, int start, int len) throws IllegalSymbolException {
                            Symbol[] syms = new Symbol[len];
                            int i = 0;
                            while (i < len) {
                                syms[i] = this.this$1.parseToken("" + data[start + i]);
                                ++i;
                            }
                            try {
                                this.val$listener.addSymbols(2.access$200(this.this$1), syms, 0, len);
                            }
                            catch (IllegalAlphabetException ex) {
                                throw new BioError(ex);
                            }
                        }

                        public void close() {
                        }
                    };
                }

                static /* synthetic */ AllTokensAlphabet access$200(2 x0) {
                    return x0.AllTokensAlphabet.this;
                }
            };
        }
        throw new NoSuchElementException("No parser for " + name + " known in alphabet " + this.getName());
    }

    public SymbolList symbols() {
        try {
            return new SimpleSymbolList(this, new ArrayList(this.symbols));
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    public int size() {
        return this.symbols.size();
    }

    public void removeSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + sym.getName() + " in " + this.getName());
    }

    protected AtomicSymbol getSymbolImpl(List symList) throws IllegalSymbolException {
        return (AtomicSymbol)symList.get(0);
    }

    public AllTokensAlphabet(String name) {
        this.name = name;
        this.symbols = new HashSet();
        this.tokenToSymbol = new HashMap();
        this.nameToSymbol = new HashMap();
    }
}

