/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;

public class SimpleSymbolList
extends AbstractSymbolList
implements Serializable {
    private static final int INCREMENT = 100;
    private Alphabet alphabet;
    private Symbol[] symbols;
    private int length;

    private void addListener() {
        this.alphabet.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alphabet.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public SimpleSymbolList(Alphabet alpha) {
        this.alphabet = alpha;
        this.length = 0;
        this.symbols = new Symbol[100];
        this.addListener();
    }

    public SimpleSymbolList(Alphabet alpha, List rList) throws IllegalSymbolException {
        this.alphabet = alpha;
        this.length = rList.size();
        this.symbols = new Symbol[this.length];
        int pos = 0;
        Iterator i = rList.iterator();
        while (i.hasNext()) {
            this.symbols[pos] = (Symbol)i.next();
            this.alphabet.validate(this.symbols[pos]);
            ++pos;
        }
        this.addListener();
    }

    public SimpleSymbolList(SymbolList sl) {
        this.alphabet = sl.getAlphabet();
        this.length = sl.length();
        this.symbols = new Symbol[this.length];
        int i = 0;
        while (i < this.length) {
            this.symbols[i] = sl.symbolAt(i + 1);
            ++i;
        }
        this.addListener();
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public int length() {
        return this.length;
    }

    public Symbol symbolAt(int pos) {
        if (pos > this.length || pos < 1) {
            throw new IndexOutOfBoundsException("Can't access " + pos + " as it is not within 1.." + this.length);
        }
        return this.symbols[pos - 1];
    }

    public void addSymbol(Symbol sym) throws IllegalSymbolException {
        this.alphabet.validate(sym);
        if (this.symbols.length <= this.length) {
            Symbol[] newSymbols = new Symbol[this.symbols.length + 100];
            System.arraycopy(this.symbols, 0, newSymbols, 0, this.length);
            this.symbols = newSymbols;
        }
        this.symbols[this.length++] = sym;
    }
}

