/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.SingletonList;

public class SingletonAlphabet
extends AbstractAlphabet
implements FiniteAlphabet,
Serializable {
    private final AtomicSymbol sym;
    private List alphabets;

    public SingletonAlphabet(AtomicSymbol sym) {
        this.sym = sym;
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    protected boolean containsImpl(AtomicSymbol s) {
        return s == this.sym;
    }

    public String getName() {
        return this.sym.getName() + "-alphabet";
    }

    public SymbolParser getParser(String name) throws NoSuchElementException {
        throw new NoSuchElementException("No parsers associated with " + this.getName() + ": " + name);
    }

    public Iterator iterator() {
        return Collections.singleton(this.sym).iterator();
    }

    public int size() {
        return 1;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public void addSymbolImpl(AtomicSymbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + sym.getName() + " in " + this.getName());
    }

    public void removeSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + sym.getName() + " in " + this.getName());
    }

    protected AtomicSymbol getSymbolImpl(List symList) throws IllegalSymbolException {
        return (AtomicSymbol)symList.get(0);
    }

    public SymbolList symbols() {
        try {
            return new SimpleSymbolList(this, Collections.nCopies(1, this.sym));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "This is impossible. I must contain me.");
        }
    }
}

