/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.query.Arc;
import org.biojava.utils.query.Node;
import org.biojava.utils.query.SimpleNode;
import org.biojava.utils.query.Type;

public interface Query {
    public Set getNodes();

    public Map getArcsToOperators();

    public Set getOperations(Arc var1);

    public Set getArcsFrom(Node var1);

    public Set getArcsTo(Node var1);

    public static class IdentityQuery
    implements Query {
        private final Node node;
        private final Set nodeSet;

        public IdentityQuery(Type type) {
            this.node = new SimpleNode("result", type);
            this.nodeSet = Collections.singleton(this.node);
        }

        public Node getNode() {
            return this.node;
        }

        public Set getNodes() {
            return this.nodeSet;
        }

        public Map getArcsToOperators() {
            return new HashMap();
        }

        public Set getOperations(Arc arc) {
            return Collections.EMPTY_SET;
        }

        public Set getArcsFrom(Node from) {
            return Collections.EMPTY_SET;
        }

        public Set getArcsTo(Node from) {
            return Collections.EMPTY_SET;
        }
    }
}

