/*
 * Network model for Editor
 *
 */

#ifndef nam_enetmodel_h
#define nam_enetmodel_h

#include "netmodel.h"

// The ratio of node radius and mean edge length in the topology

class EditorNetModel : public NetModel {
public:
	EditorNetModel(const char *animator);
	virtual ~EditorNetModel();
	void BoundingBox(BBox&);
	int addNode(float cx, float cy);
	int addLink(Node*, Node*);
	int saveAsEnam(const char*);
	int saveAsNs(const char*);
	void setNodeProperty(int,char*,int);
	void setLinkProperty(int,int,char*,int);
	void layout();
	void removeLink(Edge *);
	void removeNode(Node *);

	inline EditorNetModel* wobj() { return wobj_; }
protected:
	EditorNetModel *wobj_;
	int command(int argc, const char*const* argv);


private:
	int nID;
	double  pxmin_;
        double  pymin_;
	double  pxmax_;
        double  pymax_;

};


#endif // nam_enetmodel_h
