/*  Structs.h */
#include "../cvid/cvideo.h"

typedef int  Position[MaxDims];

typedef struct _Simple{    
	  union _Map     *prev, *next;
	  int		 type;
	  int 		 pos[MaxDims][2]; 
	  int 		 selected;
	  int            key_dimension;
 	  long 		 in, out, icon;
	  char 		 text[Nchars];
	  Window	 w;
} Simple;


typedef struct _Complex {    
	  union _Map      *prev, *next;
	  int		  type;
	  int 		  pos[MaxDims][2]; 
	  int 		  selected;
	  int		  startframe, offset;
	  float		  xoverlap, yoverlap;
	  int		  rows, columns;
	  Window	  w;
	  CVideo	  *cvideo;
} Complex;


typedef struct _Graphic {
	  union _Map      *prev, *next;
	  int		  type;
	  int 		  pos[MaxDims][2]; 
	  int 		  selected;
	  int		  x, y, xdim, ydim;
	  int		  color;
	  int		  attributes;
} Graphic;  	 


typedef union _Map {
		 	  	Simple	 simple;
	  		  	Complex	 complex; 
				Graphic	 graphic;
} Map;

typedef struct _Mapped_items {
  	   struct _Mapped_items	 *next, *prev;
	   Map		  		 *map;
}  Mapped_items;



/*   */


typedef struct _Dimension {
	  int 		 min, max, current, range;           
	  int 		 boundary;              /* response to out of bnds */
	  int		 change;		/* enable position change */
	  int		 delta_sign;		/* +/- multiplier  */
	  char 		 name[Nchars];
 } Dimension;

typedef struct _Rep {
  	Map		*m;
	int		range;
	int		(*update_fn)();
	struct _Rep	*prev, *next;
} Rep;

typedef struct _Screen{
	  int 		 type;
	  int 		 selected;
	  Window 	 w, parent;
	  int 		 x, y, width, height, borderwidth;
	  int 		 border, background;
	  Pixmap 	 border_pixmap, background_pixmap;
	  char 		 name[Nchars], parentname[Nchars], nextname[Nchars];
	  struct _Screen *prev, *next;
} Screen;

typedef struct _Element{
	  int 		  type;
	  struct _Package *p;
	  Window 	  w;          
	  Map  		  *map, *current;
	  Mapped_items   *mapped_items;
	  int 	 	  (*display_fn)();
	  int 		  active, init_active, selected;
	  char 		  file[Nchars], display_function[Nchars];
	  char		  name[Nchars], screen_name[Nchars], nextname[Nchars]; 
	  struct _Element *prev, *next;
} Element;

typedef struct _Package{
	  Element 	 *element;             
	  Screen 	 *window;       
	  Dimension 	 *dimension[MaxDims];
	  Position 	 position; 
	  int 		 ndims;                
	  int 		 active, init_active, selected;
	  char 		 name[Nchars], nextname[Nchars], screen_name[Nchars];  
	  struct _Package *prev, *next, *unext;    /* unext is user's chain */
} Package;
READFILE Package *first_package;

typedef struct _Packpos {
  	Package		*p;
	Position	pos;
	char		pname[Nchars];
} Packpos;




