/*
 *	$Source: /mit/projects/visual/RCS/lookups.c,v $
 *	$Header: lookups.c,v 1.4 87/07/08 09:59:23 joelr Exp $
 */

#ifndef lint
static char *rcsid_lookups_c = "$Header: lookups.c,v 1.4 87/07/08 09:59:23 joelr Exp $";
#endif	lint

void
signal_unexpected(what,funcname,linecount)
 char *what, *funcname;
 int linecount;
{
printf("%s: Unexpected %s at line %d.\n",funcname,what,linecount);
exit(1);
}

void
signal_missing_data(what,funcname,linecount)
     char *what, *funcname;
     int linecount;
{
  printf("%s: Missing %s at line %d\n",funcname,what,linecount);
}



#define NKEYS 23
#define PACKAGE 1
#define DSP_ELEMENT 2
#define SCR_ELEMENT 3
#define MAP 4
#define DIMENSION 5
#define INCLUDE 6
#define COMMAND 7
#define DIALOG 8
#define NAME 9
#define NEXT 10
#define TYPE 11
#define ACTIVE 12
#define LABEL 13
#define IN_POINT 14
#define OUT_POINT 15
#define ICON 16
#define FILENAME 17
#define POS_IN 18
#define POS_OUT 19
#define MAX 20
#define MIN 21
#define RANGE 22
#define BOUNDARY 23
#define SCREEN_NAME 24

/******************************************************************************
* returns value associated with string
*/
int 
lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[NKEYS] = {
    "Package", 1,
    "element", 2,
    "screen", 3,
    "map", 4,
    "dimension", 5,
    "include", 6,
    "command_button", 7,
    "name", 8,
    "next", 9,
    "type", 10,
    "active", 11,
    "label", 12,
    "in", 13,
    "out", 14,
    "icon", 15,
    "filename", 16,
    "pos_in", 17,
    "pos_out", 18,
    "max", 19,
    "min", 20,
    "range", 21,
    "boundary", 22,
    "screen_name", 23,
    
    };

  for(i=0;i<NKEYS;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}


#define FLAG -1
#define VKEYS 8
#define VIDEO 1
#define TEXT 2
/******************************************************************************
* returns value associated with string
*/
int 
lookupval(word)
 char *word;
{
  char *blank;
  char *index();
  int i;
    static struct lut {
    char *key;
    int value;
  } table[NKEYS] = {
    "yes", 1,
    "no", 0,
    "video", 1,
    "text", 2,
    "wrap",1,
    "freeze", 2,
    "bounce", 3,
    "limit", 4
    };
  if( (blank = index(word,' ')) !=0 ){
    *blank = '\0';
  }
  for(i=0;i<VKEYS;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (FLAG);
}

/* values < 8 are taken */ 
#define TKkeys 36
#define TK_WINDOW 9
#define TK_LABEL 10
#define TK_FONT 11
#define TK_BORDERWIDTH 12
#define TK_FOREGROUND 13
#define TK_BACKGROUND 14
#define TK_BORDER 15
#define TK_WIDTH 16
#define TK_HEIGTH 17
#define TK_JUSTIFY 18
#define TK_FUNCTION 19
#define TK_PARAMETER 20
#define TK_HIGHLIGHT 21 
#define TK_UNHIGHLIGHT 22
#define TK_NOTIFY 23
#define TK_ORIENTATION 24
#define TK_THUMB 25
#define TK_SCROLLUPDOWNPROC 26
#define TK_THUMBPROC 27
#define TK_TOPPERCENT 28
#define TK_SHOWNPERCENT 29
#define TK_HSPACE 30
#define TK_VSPACE 31
#define TK_DIALOGVALUE 33
#define TK_DIALOGBUTTON 34
#define TK_NAME 35
#define TK_X 36
#define TK_Y 37
/******************************************************************************
* returns value associated with string
*/
int 
TK_lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[TKkeys] = {
    "Package", 1,
    "element", 2,
    "screen", 3,
    "map", 4,
    "dimension", 5,
    "include", 6,
    "command_button", 7,
    "dialog", 8,
    "window", 9, 
    "label", 10,
    "font", 11,
    "borderwidth", 12,
    "foreground", 13,
    "background", 14,
    "border", 15,
    "width", 16,
    "height", 17,
    "justify", 18,
    "function", 19,
    "parameter", 20,
    "highlight", 21,
    "unhighlight", 22,
    "notify", 23,
    "orientation", 24,
    "thumb", 25,
    "scrollupdownproc", 26,
    "thumbproc", 27,
    "toppercent", 28,
    "shownpercent", 29,
    "hspace", 30,
    "vspace", 31,
    "dialogvalue", 32,
    "dialogbutton", 33,
    "name", 34,
    "x", 35,
    "y", 36
    };

  for(i=0;i<TKkeys;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}
#define Fkeys 2
#define INTFUNCTION 1
#define STRINGFUNCTION 2
char * /* was int */
lookup_function(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    char * value; /* was itn */
  } table[Fkeys] = {
    "IntFunction", (char *)IntFunction,
    "StringFunction", (char *)StringFunction,
     };

  for(i=0;i<TKkeys;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}
