
/* swtr_driver.h */

/* this is set up for an Nx1 crosspoint switcher at the moment;
	that is, no visual effects */

/* 
	Each input (source) has 3 channels: video, left audio, and right audio.
	Since there is just one output on the switcher (which goes to
	the user's display), it is simplest to think in terms of which
	input gets patched to each output channel. So we would say that "the
	video is coming from source #2". We can also say that "all channels
	are coming from source #2".
*/


#ifndef SWTR_DRIVER_H
#define SWTR_DRIVER_H

typedef int (*SWTR_METHOD)();

#define VIDEO_CHAN	1	
#define LEFT_CHAN	2
#define RIGHT_CHAN	3
#define ALL_CHAN	4

/* maximum number of outputs (each with 3 separate channels: V,A1,A2) on the switcher */
#define MAXOUTPUTS	6	

typedef struct 
{
	int		fd;		/* the file for talking */
	char		port[16];	/* tty_port name - for debugging */
	char		model[32];	/* manufacturer's name */
	char		devname[32];	/* logical name */

	unsigned char	inputs;		/* number of source inputs */
	unsigned char	outputs;	/* number of sink outputs */

	struct
	{
		unsigned char	VideoSource;
		unsigned char	LeftSource;
		unsigned char	RightSource;
	} state [MAXOUTPUTS];		/* one state record per output */

	SWTR_METHOD		reset;		/* no args */
	SWTR_METHOD		set_chan_src;	/* 3 args: ( channel, input_num, output_num ) */
	SWTR_METHOD		inquire;	/* 4 args: 1 input, 3 output: 
					   (output, &video, &left, &right) */

} SWTR, *SWTR_ptr;

SWTR_ptr	swtrutil_open();	/* given a video.conf table and a device index */
SWTR_ptr	swtrutil_close();	/* given a SWTR_ptr */

#endif SWTR_DRIVER_H
