
environment Xtest
{

	-- declarations section; all of the C globals which can be accessed

	Cint	theTextBuffer;

	Cfunc	theObj() returns Cstr;
	Cfunc	theEnv() returns Cstr;
	Cfunc	theCode() returns Cstr;

	Cfunc	XtTextUnsetSelection( Cint );
	Cfunc	GetTextEditorPos( Cint, Cstr, Cstr );
	Cfunc	SetTextEditorPos( Cint, Cint, Cint );
	Cfunc	GetTextEditorSelection( Cstr ) returns Cint;
	Cfunc	TextEditorReplace( Cint, Cint, Cint, Cstr );
	Cfunc	QueryWindow( Cint, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	ChangeWindow( Cint, Cint, Cint );
	Cfunc	QueryHeight( Cint ) returns Cint;
	Cfunc	XQueryWidth( Cstr, Cint ) returns Cint;
	Cfunc	GXCOPY() returns Cint;
	Cfunc	ALLPLANES() returns Cint;
	Cfunc	myWindow() returns Cint;
	Cfunc	GetAFont( Cstr ) returns Cint;
	Cfunc	ShowText( Cint, Cint, Cint, Cstr, Cint, Cint, Cint );
	Cfunc	theRoot() returns Cint;	
	Cfunc	WhitePM() returns Cint;
	Cfunc	BlackPM() returns Cint;
	Cfunc	MakeWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	RegisterWindow( Cint, Cstr );
	Cfunc	MapWindow( Cint );
	Cfunc	MapChildren( Cint );
	Cfunc	UnMap( Cint );
	Cfunc	ClearWindow( Cint );
	Cfunc	strlen( Cstr ) returns Cint;
	Cfunc	FlushEvents();
	Cfunc	Beep();
	Cfunc	MoveWindow( Cint, Cint, Cint );
	Cfunc	MakeButton( Cint, Cint, Cint, Cstr ) returns Cint;
	Cfunc	MakeButtonBox( Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	AddToButtonBox( Cint, Cint );
	Cfunc	MakeAskFor( Cint, Cstr, Cstr, Cint, Cint ) returns Cint;
	Cfunc	GetAskForString( Cint ) returns Cstr;
	Cfunc	MakeTextEditor( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	XtSendDestroyNotify( Cint );
	Cfunc	XDestroyWindow( Cint );
	Cfunc	Quit();
	Cfunc	MakeMenuBarWindow( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	MenuBarHeight() returns Cint;
	Cfunc	SetIconWindow( Cint, Cint );
	Cfunc	IconSwitch( Cint );
	Cfunc	MakePixmap( Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XPixmapPut( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );
	Cfunc	MakeCursor( Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XDefineCursor( Cint, Cint );
	Cfunc	XUndefineCursor( Cint );
	Cfunc	GetColor( Cstr ) returns Cint;

	Cfunc	RegisterTW( Cint );
	Cfunc	DeRegisterTW( Cint );
	Cfunc	WindowFromTW( Cint ) returns Cint;

	Cfunc	TextCreate( Cint, Cint, Cint, Cint, Cint, 
			Cstr, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	TextDestroy( Cint );
	Cfunc	TextClear( Cint );
	Cfunc	TextRedisplay( Cint );
	Cfunc	TextPutString( Cint, Cstr );
	Cfunc	TextPutChar( Cint, Cint );
	Cfunc	TextPutLine( Cint, Cstr );
	Cfunc	TextFlush( Cint );	

	var 	theResult;
	var 	theFont;
	var	theEditor;
	var	theMenu;
	var	theCursor;
	var	TextWinPtr;
	var	theTextWindow;

	-- end of C declarations

	function GetIconWindowSize( iw, ih, name, f, width, height )
	{
		put XQueryWidth( name, f ) into strWidth;
		put QueryHeight( f ) into strHeight;
		put (strWidth+20) into w;
		if( (iw+20) > w )
			{ put (iw+20) into w; }
		put ((strHeight+ih)+30) into h;
		put w into width;	-- return this value
		put h into height;	-- return this value
	}

	function PlotIcon( window, pm, iw,ih, name, f )
	{
		put ("w: "&window) into p;
		put ((p&"; pm: ")&pm) into p;
		put ((p&"; iw: ")&iw) into p;
		put ((p&"; ih: ")&ih) into p;
		put ((p&"; n: ")&name) into p;
		put ((p&"; f: ")&f) into p;

		TextPutLine( TextWinPtr, p );

		QueryWindow( window, w,h,x,y, bdr, mapped, type, assoc );
		put 10 into destSX;
		put (ih+20) into destSY;
		put ((w-iw)/2) into destIX;  -- center icon width-wise
		put 10 into destIY;
		XPixmapPut( window, 0,0,destIX,destIY,iw,ih,pm,
			GXCOPY(), ALLPLANES() );
		ShowText( window, destSX,destSY, name, strlen(name), f, 0 );
	}

	on OpenEnv
	{
		put GetAFont( "timrom12b" ) into theFont;
		put MakeCursor( "left_ptr.cursor", "left_ptr_mask.cursor",
			"black", "white" ) into theCursor;
		XDefineCursor( theRoot(), theCursor );
		put TextCreate( 80,24,750,100,theRoot(),
			"8x13",2,0,1,BlackPM(),1 ) into TextWinPtr;
		RegisterTW( TextWinPtr );	-- VERY IMPORTANT!!
		put WindowFromTW( TextWinPtr ) into theTextWindow;
		MapWindow( theTextWindow );

		put MakeButtonBox( theRoot(), 550,100,300,100 ) into bbw;
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Beep" ) );
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Edit File" ) );
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Close" ) );
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Quit" ) );

		MapWindow( bbw );
		MapChildren( bbw );
		FlushEvents();
	}

	object Close
	{
		on Activate
		{
			if( theEditor > 0 ) 
			{
				XtSendDestroyNotify( theEditor );
				XDestroyWindow( theEditor );
				put 0 into theEditor;
			}
			if( theMenu > 0 )
			{
				XDestroyWindow( theMenu );
				put 0 into theMenu;
			}
		}	
	}

	object "Edit File"
	{
		var DialogWaiting;
		var DialogWindow;

		on Activate
		{
			if( DialogWaiting > 0 ){ exit Activate; }
			if( theEditor > 0 ) { exit Activate; }
			put MakeAskFor( theRoot(), 
				"Enter name of file to edit:", "xtk.xs", 
				550, 175 ) into DialogWindow;
			MapWindow( DialogWindow );
			put 1 into DialogWaiting;
		}

		on okay
		{
			put GetAskForString( DialogWindow ) into theFile;
			UnMap( DialogWindow );
			put 0 into DialogWaiting;
			put MakeMenuBarWindow( theRoot(), "Text Editor",
				50, 200, ((80*6)+40), ((24*10)+40) ) into theMenu;
			put MakeTextEditor( theMenu, theFile,
				20, (MenuBarHeight()+20), (80*6), (24*10)  ) 
				into theEditor;
			if( theEditor = 0 )
			{ 
				put "Unable to edit file" into theResult;
				TextPutLine( TextWinPtr, "Unable to edit file" );
				exit okay;
			}
			if( theMenu > 0 ) 
			{
				put (((("SetIcon "&theMenu)&" `Text Editor: ")&theFile)&"`")
					into theMsg;
				send theMsg to "IconWindow";
				MapWindow( theMenu ); 
				MapChildren( theMenu );
				MapWindow( theEditor );
			}

		}

		on cancel
		{
			UnMap( DialogWindow );
			put 0 into DialogWaiting;
			TextPutLine( TextWinPtr, "Cancel selected" );
		}
	}

	object IconWindow
	{
		var	myPixmap;
		var	theIcon;
		var	IconW;
		var	IconH;
		var	IconWindowW;
		var	IconWindowH;
		var	IconName;

		on SetIcon	mainWindow,theName
		{
			put (("SetIcon: "&mainWindow)&(" "&theName)) into text;
			TextPutLine( TextWinPtr, text );
			if( myPixmap = 0 )
			{
				put MakePixmap( "menuicon.bitmap", 
					"Firebrick", "CadetBlue", IconW, IconH ) 
						into myPixmap;
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				put MakeWindow( theRoot(), 100, 100, 
					IconWindowW, IconWindowH,
					2, BlackPM(), WhitePM() )
						into theIcon;
				RegisterWindow( theIcon, theObj() );
			}
			else	-- icon already made, name may have changed
			{
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				ChangeWindow( theIcon, IconWindowW, IconWindowH );
			}
			put theName into IconName;
			SetIconWindow( mainWindow, myWindow() );
		}

		on ExposeWindow
		{
			PlotIcon( myWindow(), myPixmap, IconW, IconH, IconName, theFont );
		}

		on ExposeRegion
		{
			PlotIcon( myWindow(), myPixmap, IconW, IconH, IconName, theFont );
		}

		on ButtonPressed
		{
			IconSwitch( myWindow() );
		}
	}

	object "Text Editor"
	{
		on NameHit
		{
			TextPutLine( TextWinPtr, "Hit Namebar" );
			IconSwitch( theMenu );
		}

		on MenuHit	menu,item
		{
			put ("Menu: "&menu) into p1;
			put ("; Item: "&item) into p2;
			put (p1 & p2) into text;
			TextPutLine( TextWinPtr, text );
			if( menu = "File" )
			{
				if( item = "Close" )
					{ send "Activate" to "Close"; }
			}
			else if( menu = "Edit" )
			{ 
				if( item = "Cut" )
				{
					GetTextEditorPos( theEditor, beg, end );
					GetTextEditorSelection( nbytes );
					TextPutLine( TextWinPtr, 
						(("Cut: "&beg)&(","&end)) );
					TextEditorReplace( theEditor, beg, end, "");
					SetTextEditorPos( theEditor, beg, beg );
				}
				else if( item = "Copy" )
				{
					GetTextEditorPos( theEditor, beg, end );
					GetTextEditorSelection( nbytes );
					TextPutLine( TextWinPtr, 
						(("Cut: "&beg)&(","&end)) );
					TextEditorReplace( theEditor, beg, end, 
						theTextBuffer );
				}
				else if( item = "Paste" )
				{
					XtTextUnsetSelection( theEditor );
					GetTextEditorPos( theEditor, beg, end );
					TextEditorReplace( theEditor, beg, beg, 
						theTextBuffer );
				}
			}
		}
	}

	object Okay
	{
		on Activate
		{ send "okay" to "Edit File"; }
	}

	object Cancel
	{
		on Activate
		{ send "cancel" to "Edit File"; }
	}

	object Beep { on Activate { Beep(); } }

	object Quit { on Activate { Quit(); } }

}
