/* 
 * scr.c - modifies demo1; adds a scroll bar
 *
 * Make executable with:
 *	cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>
#include <signal.h>
#include <sys/time.h>

#define TIMELIMIT 60
#define YES 1
#define NO 0
#define MAXMARKS 50

#define addbutton(w)\
    buttons[buttoncount].name = XtAWindow;\
    buttons[buttoncount].value = (caddr_t)w;\
    buttoncount++;

#define BORDERWIDTH 2
/***************
*  Windows needed
*/
Window windowid;
Window   sw;  /*scroll window */
Window timewindow;  /* time display */
Window butbox;  /* button box window */
Window fwd, rev, stp, mrk;  /* command button windows */


/***************
*  General global stuff
*/
XEvent rp, *rep = &rp;
Font f;
int len;
char *msg[30];
int time;
int timeinc = 1;
int time_is_on = NO;
int count_marks;
int mark[MAXMARKS];

/***************
*  Timer stuff
*/
struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;





/***************************************************
*  Control button procedures
*/
static void Forward()
{
if(! time_is_on){  
  time_is_on = YES; 
 }

timeinc = 1;
}


static void Reverse()
{
if(! time_is_on){
  time_is_on = YES;
 }

timeinc = -1;
}


static void Stop()
{
time_is_on = NO;
}

static void Mark()
{
if(++count_marks < MAXMARKS){
  mark[count_marks] = time;
 }
else printf("Marks array is full.\n");
}



static char mrk_label[] = "Mark";
static char fwd_label[] = "Forward";
static char rev_label[] = "Reverse";
static char stp_label[] = "Stop";




static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) fwd_label},
    {XtAFunction, (caddr_t) Forward},
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}	/* needed to terminate argument list */
};

static Arg bbarglist[] = {
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}
};

/******************************************************
*  Scroll Window stuff
*/
static void Scr1(scrW, cliW, intpos)
  Window scrW;
  Window cliW;
  int intpos;
{
  printf("pos %d\n",intpos);
}

static void Thmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{

  time = (tp/100)*TIMELIMIT;
  sprintf(msg,"Time %d   ",time);
  len = strlen(msg);

  XText(windowid,
	540,510,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
  
}
  
static Arg scrargs[] = {
  {XtAOrientation, (caddr_t) XtAhorizontal},
  {XtAWidth, (caddr_t) 630},
  {XtAHeight, (caddr_t) 20},
  {XtABorderWidth, (caddr_t) BORDERWIDTH},
  {XtAScrollUpDownProc, (caddr_t) Scr1},
  {XtAThumbProc, (caddr_t) Thmb},
  {NULL, NULL}
};



int timer();
int tries = 0;
int time;



/********************************************************
*  MAIN
*/

void main()
{
    Display  *d;


int count = 0;
int len;
char *msg[30];
Arg buttons[4];
int buttoncount;


if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1);
   }

if(tries == 1){
  windowid = XCreateWindow(RootWindow,
			 50,
			 50,
			 640,
			 550,
			 3,
			 BlackPixmap,
			 WhitePixmap);


  XMapWindow(windowid);

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }



  XSelectInput(windowid, 1);




    XtInitToolkit();

    butbox = XtCreateButtonBox(windowid,bbarglist);

    buttonArgs[0].value = (caddr_t) fwd_label;
    buttonArgs[1].value = (caddr_t) Forward;
    fwd = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(fwd);
    addbutton(fwd);

    buttonArgs[0].value = (caddr_t) stp_label;
    buttonArgs[1].value = (caddr_t) Stop;
    stp = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(stp);
    addbutton(stp);

    buttonArgs[0].value = (caddr_t) rev_label;
    buttonArgs[1].value = (caddr_t) Reverse;
    rev = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(rev);
    addbutton(rev);

    buttonArgs[0].value = (caddr_t) mrk_label;
    buttonArgs[1].value = (caddr_t) Mark;
    mrk = XtCreateCommand(butbox, buttonArgs);
    XMapWindow(mrk);
    addbutton(mrk);

    (void)XtButtonBoxAddButton(butbox,buttons);

    /* widget clients normally position, size and map widget windows */
    XMoveWindow(butbox, 5,510);
    XMapWindow(butbox);




    sw = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(sw, 5, 485);
    XMapWindow(sw);


  timvl.it_value.tv_sec = 0;
  timvl.it_value.tv_usec = 33;
  timvl.it_interval.tv_sec = 0;
  timvl.it_interval.tv_usec = 33;

  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();
}







    for(;;) {
	XEvent ev;

	XNextEvent(&ev);		/* Get next event */
	(void) XtDispatchXEvent(&ev);	/* Hand it to Toolkit Dispatcher */
    }
}









int 
timer()
{

  char *msg[30];
  int len;
  float tp,sp;
  float fti;
  int count = 0;

if(time_is_on){
  time = time + timeinc;
  if(time < 0) time = 0;
  if(time > TIMELIMIT) time = 0;


  sprintf(msg,"Time %d  ",time);
  len = strlen(msg);

  XText(windowid,
	540,510,msg,len,f,BlackPixel,WhitePixel);
  XFlush();

  tp = ((fti=time)/TIMELIMIT)*100;
  sp = 0; 
  XtSetScrollBarPercentages(sw,tp,sp);
 }


}

