
/* XCreateVideoWindow.c : ripped off from XCreateWindow
/* RMS 6/10/87
/*
/* This routine will let you create a video window which is a child
/* of another (parent) window. This is logically useful, but don't you
/* dare try to move that parent until we get a new version of the server.
/* If the coords don't work out just right, at best your display is
/* trashed and at worst you get coffee while the machine reboots.
 */


#include <X/mit-copyright.h>

/* $Header: XCreateWindow.c,v 10.5 86/04/22 15:27:38 jg Rel $ */
/* Copyright    Massachusetts Institute of Technology    1985	*/


/* 
/* Modified by RMS for video parameter checking on width and x-coord.
/* The Parallax expects a video region to live on modulo-16 x-coord,
/* and to have a width that is also modulo-16.
 */

/* the following is declared and initialized at cc-time in Xvid.c */
extern int	VideoInitialized;

#include "XlibInternal.h"

#define SCOPE extern
#include "XVideo.h"

Window XCreateVideoWindow(parent, x, y, width, height, bdr_width, border, bgnd)

	int x, y, width, height, bdr_width;
	Window parent;
	Pixmap border, bgnd;
{
	register Display *dpy;
	register XReq *req;
	XRep rep;
	int	rel_x,rel_y;
	int	abs_x,abs_y;

	/* get parent window's screen offset */

	Get_Absolute_Coords( parent, 0,0, &abs_x, &abs_y );
	abs_x += x;
	abs_y += y;

	/* take care of border width, so we still are on MOD_16 x */

	abs_x -= bdr_width;
	if( !MOD_16(abs_x) )
		abs_x = ROUND_16(abs_x);
	if( !MOD_16(width) )
		width = ROUND_16(width);

	/* convert back to parent-relative coords */

	Get_Relative_Coords( parent, &rel_x, &rel_y, abs_x, abs_y );

	/* try to do something intelligent if not on Parallax */
	if( !VideoInitialized ) XSetVideoDisplay();

	GetReq(X_CreateWindow, parent);
	req->params0 = height;
	req->params1 = width;
	req->params2 = rel_x;
	req->params3 = rel_y;
	req->param.l[2] = border;
	req->param.l[3] = bgnd;
	req->func = bdr_width;

	if( !VideoDevice )
		req->param.l[3] = vback_pixmap;

	if (!_XReply(dpy, &rep))
	    return(NULL);
	return (rep.param.l[0]);
}
