/*
 * main.c - Debugging code for now, but should turn into a real invokable
 *          scripting thingy.
 *
 * Copyright (C) 1997, George Madrid
 * All Rights Reserved
 */

#include <stdio.h>

#include "config.h"
#include "utils.h"
#include "nsobj.h"

void test_print(nsObj nso);

int
main(int argc, char *argv[])
{
     nsObj nso, nso2;
     
     ns_initialize();

     nso = make_integer(0);
     test_print(nso);
     nso = make_integer(5);
     test_print(nso);
     nso = make_character('c');
     test_print(nso);
     nso = make_boolean(54);
     test_print(nso);
     nso = make_boolean(0);
     test_print(nso);

     /* Try making this work with oh, 10 bytes */
     nso = make_binary(10, make_symbol("RandomBinaryObject"));
     test_print(nso);
     nso = make_string("Some string here");
     test_print(nso);
     nso = make_symbol("Symbol");
     test_print(nso);

     /* Try out some array stuff */
     nso = make_array(3, NS_NIL);
     nso_setARef(nso, make_integer(0), NS_TRUE);
     nso_setARef(nso, make_integer(1), make_symbol("Element"));
     nso_setARef(nso, make_integer(2), make_string("Hi, Evan!"));
     nso_AddArraySlot(nso, make_character('/'));
     nso2 = make_array(2, nso);
     test_print(nso2);
     test_print(nso_ARef(nso, make_integer(0)));
     test_print(nso_ARef(nso, make_integer(2)));

     nso = make_naked_frame(NULL);

     return(0);
}

void
test_print(nsObj nso)
{
     nso_print(nso);
     fputc('\n', stdout);
}
