/* linux/arch/arm/mach-s3c2410/mach-rx1950.c
 *
 * Copyright (c) 2003-2005 Simtec Electronics
 *   Ben Dooks <ben@simtec.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Originally for smdk2440 modified for rx1950 by Denis Grigoriev and Victor Chukhantsev
*/

#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/list.h>
#include <linux/timer.h>
#include <linux/init.h>
#include <linux/platform_device.h>

#include <linux/mtd/mtd.h>
#include <linux/mtd/nand.h>
#include <linux/mtd/nand_ecc.h>
#include <linux/mtd/partitions.h>

#include <linux/input_pda.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/irq.h>

#include <asm/hardware/gpio_keys.h>
#include <asm/hardware.h>
#include <asm/hardware/iomd.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/mach-types.h>

#include <asm/arch/regs-serial.h>
#include <asm/arch/regs-gpio.h>
#include <asm/arch/regs-lcd.h>
#include <asm/arch/buttons.h>
#include <asm/arch/ts.h>
#include <asm/arch/fb.h>
#include <asm/arch/nand.h>

#include <linux/serial_core.h>

#include "clock.h"
#include "devs.h"
#include "cpu.h"
#include "pm.h"

static struct map_desc rx1950_iodesc[] __initdata = {
	        /* dump ISA space somewhere unused */
	        {
			.virtual        = (u32)S3C24XX_VA_ISA_WORD,
			.pfn            = __phys_to_pfn(S3C2410_CS3),
			.length         = SZ_1M,
			.type           = MT_DEVICE,
		}, {
			.virtual        = (u32)S3C24XX_VA_ISA_BYTE,
			.pfn            = __phys_to_pfn(S3C2410_CS3),
			.length         = SZ_1M,
			.type           = MT_DEVICE,
		},
		};

#define UCON S3C2410_UCON_DEFAULT | S3C2410_UCON_UCLK
#define ULCON S3C2410_LCON_CS8 | S3C2410_LCON_PNONE | S3C2410_LCON_STOPB
#define UFCON S3C2410_UFCON_RXTRIG8 | S3C2410_UFCON_FIFOMODE

static struct s3c24xx_uart_clksrc rx1950_serial_clocks[] = {
        [0] = {
                .name           = "fclk",
                .divisor        = 0x0a,
                .min_baud       = 0,
                .max_baud       = 0,
        }
};


static struct s3c2410_uartcfg rx1950_uartcfgs[] __initdata = {
	[0] = {
		.hwport	     = 0,
		.flags	     = 0,
		.ucon	     = 0x3c5,
		.ulcon	     = 0x03,
		.ufcon	     = 0x51,
                .clocks      = rx1950_serial_clocks,
                .clocks_size = ARRAY_SIZE(rx1950_serial_clocks),
	},
	[1] = {
		.hwport	     = 1,
		.flags	     = 0,
		.ucon	     = 0x245,
		.ulcon	     = 0x03,
		.ufcon	     = 0x00,
	},
	/* IR port */
	[2] = {
		.hwport	     = 2,
		.flags	     = 0,
		.uart_flags  = UPF_CONS_FLOW,
		.ucon	     = 0x3c5,
		.ulcon	     = 0x43,
		.ufcon	     = 0x51,
	}
};

/* Board control latch control */

//static unsigned int latch_state = H1940_LATCH_DEFAULT;

void rx1950_latch_control(unsigned int clear, unsigned int set)
{
//	unsigned long flags;

//	local_irq_save(flags);

//	latch_state &= ~clear;
//	latch_state |= set;

//	__raw_writel(latch_state, H1940_LATCH);

//	local_irq_restore(flags);
}

EXPORT_SYMBOL_GPL(rx1950_latch_control);


/**
 * Set lcd on or off
 **/
static struct s3c2410fb_mach_info rx1950_lcdcfg __initdata = {
	.fixed_syncs=		1,
	.regs={
		.lcdcon1=	S3C2410_LCDCON1_TFT16BPP | \
				S3C2410_LCDCON1_TFT | \
				S3C2410_LCDCON1_CLKVAL(0x0C),

		.lcdcon2=	S3C2410_LCDCON2_VBPD(7) | \
				S3C2410_LCDCON2_LINEVAL(319) | \
				S3C2410_LCDCON2_VFPD(6) | \
				S3C2410_LCDCON2_VSPW(0),

		.lcdcon3=	S3C2410_LCDCON3_HBPD(25) | \
				S3C2410_LCDCON3_HOZVAL(239) | \
				S3C2410_LCDCON3_HFPD(25),

		.lcdcon4=	S3C2410_LCDCON4_MVAL(0) | \
				S3C2410_LCDCON4_HSPW(3),

		.lcdcon5=	S3C2410_LCDCON5_FRM565 | \
				S3C2410_LCDCON5_INVVLINE | \
				S3C2410_LCDCON5_HWSWP,
	},
	.lpcsel=	0x02,
//	.gpccon=	0xaa940659,
//	.gpccon_mask=	0xffffffff,
//	.gpcup=		0x0000ffff,
//	.gpcup_mask=	0xffffffff,
//	.gpdcon=	0xaa84aaa0,
//	.gpdcon_mask=	0xffffffff,
//	.gpdup=		0x0000faff,
//	.gpdup_mask=	0xffffffff,

	.width=		240,
	.height=	320,
	.xres=		{240,240,240},
	.yres=		{320,320,320},
	.bpp=		{16,16,16},
};

static struct mtd_partition rx1950_nand_part[] = {
        [0] = {
                .name           = "Whole Flash",
                .offset         = 0,
                .size           = MTDPART_SIZ_FULL,
                .mask_flags     = MTD_WRITEABLE,
        }
};

static struct s3c2410_nand_set rx1950_nand_sets[] = {
        [0] = {
                .name           = "Internal",
                .nr_chips       = 1,
                .nr_partitions  = ARRAY_SIZE(rx1950_nand_part),
                .partitions     = rx1950_nand_part,
        },
};

static struct s3c2410_platform_nand rx1950_nand_info = {
        .tacls          = 25,
        .twrph0         = 50,
        .twrph1         = 15,
        .nr_sets        = ARRAY_SIZE(rx1950_nand_sets),
        .sets           = rx1950_nand_sets,
};

static struct s3c2410_ts_mach_info rx1950_ts_cfg __initdata = {
		.delay = 10000,
		.presc = 49,
		.oversampling_shift = 2,
};

static struct gpio_keys_button rx1950_gpio_keys_table[] = {
 {_KEY_POWER, S3C2410_GPF0, 1, "Power button"},
 {_KEY_RECORD, S3C2410_GPF7, 1, "Record button"},
 {_KEY_APP1, S3C2410_GPG0, 1, "Calendar button"},
 {_KEY_APP2, S3C2410_GPG2, 1, "Contacts button"},
 {_KEY_APP3, S3C2410_GPG3, 1, "Mail button"},
 {_KEY_APP4, S3C2410_GPG7, 1, "Home button"},
 {KEY_LEFT, S3C2410_GPG10, 1, "Calendar button"},
 {KEY_RIGHT, S3C2410_GPG11, 1, "Contacts button"},
 {KEY_UP, S3C2410_GPG4, 1, "Mail button"},
 {KEY_DOWN, S3C2410_GPG6, 1, "Home button"},
 {KEY_ENTER, S3C2410_GPG9, 1, "Ok button"},
};

static struct gpio_keys_platform_data rx1950_gpio_keys_data = {
	.buttons	= rx1950_gpio_keys_table,
	.nbuttons	= ARRAY_SIZE(rx1950_gpio_keys_table),
};

static struct platform_device rx1950_device_gpiokeys = {
	.name		= "gpio-keys",
	.dev = { .platform_data = &rx1950_gpio_keys_data, }
};

static struct platform_device *rx1950_devices[] __initdata = {
	&s3c_device_usb,
	&s3c_device_lcd,
	&s3c_device_wdt,
	&s3c_device_i2c,
	&s3c_device_iis,
	&s3c_device_rtc,
	&s3c_device_nand,
	&s3c_device_sdi,
	&s3c_device_ts,
	&rx1950_device_gpiokeys,	
};

static struct s3c24xx_board rx1950_board __initdata = {
	.devices       = rx1950_devices,
	.devices_count = ARRAY_SIZE(rx1950_devices)
};

static void __init rx1950_map_io(void)
{
	s3c24xx_init_io(rx1950_iodesc, ARRAY_SIZE(rx1950_iodesc));
	//s3c24xx_init_clocks(0);
	s3c24xx_init_clocks(16934000);
	s3c24xx_init_uarts(rx1950_uartcfgs, ARRAY_SIZE(rx1950_uartcfgs));
	s3c24xx_set_board(&rx1950_board);
}

static void __init rx1950_init_irq(void)
{
  s3c24xx_init_irq();
}

static void __init rx1950_init_machine(void)
{
	printk("rx1950 init()\n");
	s3c24xx_fb_set_platdata(&rx1950_lcdcfg);
	s3c_device_nand.dev.platform_data = &rx1950_nand_info;
	set_s3c2410ts_info(&rx1950_ts_cfg);
	s3c2410_pm_init();
}


MACHINE_START(H1940, "IPAQ-RX1950")
	/* Maintainer: Ben Dooks <ben@fluff.org> */
	.phys_io	= S3C2410_PA_UART,
	.io_pg_offst	= (((u32)S3C24XX_VA_UART) >> 18) & 0xfffc,
	.boot_params	= S3C2410_SDRAM_PA + 0x100,
	.map_io		= rx1950_map_io,
	.init_irq	= rx1950_init_irq,
	.init_machine   = rx1950_init_machine,
	.timer		= &s3c24xx_timer,
MACHINE_END
