/** @file host.h
  *
  * @brief This file contains definitions of WLAN commands.
  *  
  * (c) Copyright  2003-2006, Marvell International Ltd. 
  * All Rights Reserved
  *
  * This software file (the "File") is distributed by Marvell International 
  * Ltd. under the terms of the GNU General Public License Version 2, June 1991 
  * (the "License").  You may use, redistribute and/or modify this File in 
  * accordance with the terms and conditions of the License, a copy of which 
  * is available along with the File in the license.txt file or by writing to 
  * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
  * 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
  *
  * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE 
  * IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE 
  * ARE EXPRESSLY DISCLAIMED.  The License provides additional details about 
  * this warranty disclaimer.
  *
  */
/********************************************************
Change log:
    10/11/05: Add Doxygen format comments
    01/11/06: Remove assoc response codes; full IEEE assoc resp now returned
    04/06/06: Add TSPEC, queue metrics, and MSDU expiry support
    04/10/06: Add power_adapt_cfg_ext command
    04/18/06: Remove old Subscrive Event and add new Subscribe Event
	      implementation through generic hostcmd API
********************************************************/

#ifndef _HOST_H_
#define _HOST_H_

/** PUBLIC DEFINITIONS */
#define DEFAULT_CHANNEL              1
#define DEFAULT_CHANNEL_A           36
#define DEFAULT_AD_HOC_CHANNEL       6
#define DEFAULT_AD_HOC_CHANNEL_A    36

/** IEEE 802.11 OIDs */
#define OID_802_11_BSSID                      0x00008001
#define OID_802_11_SSID                       0x00008002
#define OID_802_11_NETWORK_TYPES_SUPPORTED    0x00008003
#define OID_802_11_NETWORK_TYPE_IN_USE        0x00008004
#define OID_802_11_RSSI                       0x00008006
#define OID_802_11_RSSI_TRIGGER               0x00008007
#define OID_802_11_INFRASTRUCTURE_MODE        0x00008008
#define OID_802_11_FRAGMENTATION_THRESHOLD    0x00008009
#define OID_802_11_RTS_THRESHOLD              0x0000800A
#define OID_802_11_NUMBER_OF_ANTENNAS         0x0000800B
#define OID_802_11_RX_ANTENNA_SELECTED        0x0000800C
#define OID_802_11_TX_ANTENNA_SELECTED        0x0000800D
#define OID_802_11_SUPPORTED_RATES            0x0000800E
#define OID_802_11_DESIRED_RATES              0x00008010
#define OID_802_11_CONFIGURATION              0x00008011
#define OID_802_11_STATISTICS                 0x00008012
#define OID_802_11_ADD_WEP                    0x00008013
#define OID_802_11_REMOVE_WEP                 0x00008014
#define OID_802_11_DISASSOCIATE               0x00008015
#define OID_802_11_POWER_MODE                 0x00008016
#define OID_802_11_BSSID_LIST                 0x00008017
#define OID_802_11_AUTHENTICATION_MODE        0x00008018
#define OID_802_11_PRIVACY_FILTER             0x00008019
#define OID_802_11_BSSID_LIST_SCAN            0x0000801A
#define OID_802_11_WEP_STATUS                 0x0000801B
#define OID_802_11_RELOAD_DEFAULTS            0x0000801C
#define OID_802_11_TX_RETRYCOUNT              0x0000801D
#define OID_802_11D_ENABLE                    0x00008020

/** Marvel specific OIDs */
#define OID_MRVL_OEM_GET_ULONG                0xff010201
#define OID_MRVL_OEM_SET_ULONG                0xff010202
#define OID_MRVL_OEM_GET_STRING               0xff010203
#define OID_MRVL_OEM_COMMAND                  0xff010204

/** Command Processing States and Options */
#define HostCmd_STATE_IDLE                    0x0000
#define HostCmd_STATE_IN_USE_BY_HOST          0x0001
#define HostCmd_STATE_IN_USE_BY_MINIPORT      0x0002
#define HostCmd_STATE_FINISHED                0x000f

#define HostCmd_Q_NONE                        0x0000
#define HostCmd_Q_INIT                        0x0001
#define HostCmd_Q_RESET                       0x0002
#define HostCmd_Q_STAT                        0x0003

#define HostCmd_OPTION_WAITFORRSP             0x0002

/*  512 usec */
#define HostCmd_DELAY_NORMAL                  0x00000200
/*  256 usec */
#define HostCmd_DELAY_MIN                     0x00000100      
/* 1024 usec */
#define HostCmd_DELAY_MAX                     0x00000400      


/** Host Command ID */
#define HostCmd_CMD_NONE                      0x0000
#define HostCmd_CMD_CODE_DNLD                 0x0002
#define HostCmd_CMD_GET_HW_SPEC               0x0003
#define HostCmd_CMD_EEPROM_UPDATE             0x0004
#define HostCmd_CMD_802_11_RESET              0x0005
#define HostCmd_CMD_802_11_SCAN               0x0006
#define HostCmd_CMD_802_11_GET_LOG            0x000b
#define HostCmd_CMD_MAC_MULTICAST_ADR         0x0010
#define HostCmd_CMD_802_11_AUTHENTICATE       0x0011
#define HostCmd_CMD_802_11_EEPROM_ACCESS      0x0059
#define HostCmd_CMD_802_11_ASSOCIATE          0x0050
#define HostCmd_CMD_802_11_SET_WEP            0x0013
#define HostCmd_CMD_802_11_GET_STAT           0x0014
#define HostCmd_CMD_802_3_GET_STAT            0x0015
#define HostCmd_CMD_802_11_SNMP_MIB           0x0016
#define HostCmd_CMD_MAC_REG_MAP               0x0017
#define HostCmd_CMD_BBP_REG_MAP               0x0018
#define HostCmd_CMD_MAC_REG_ACCESS            0x0019
#define HostCmd_CMD_BBP_REG_ACCESS            0x001a
#define HostCmd_CMD_RF_REG_ACCESS             0x001b
#define HostCmd_CMD_802_11_RADIO_CONTROL      0x001c
#define HostCmd_CMD_802_11_RF_CHANNEL         0x001d
#define HostCmd_CMD_802_11_RF_TX_POWER        0x001e
#define HostCmd_CMD_802_11_RSSI               0x001f
#define HostCmd_CMD_802_11_RF_ANTENNA         0x0020

#define HostCmd_CMD_802_11_PS_MODE	      0x0021

#define HostCmd_CMD_802_11_DATA_RATE          0x0022
#define HostCmd_CMD_RF_REG_MAP                0x0023
#define HostCmd_CMD_802_11_DEAUTHENTICATE     0x0024
#define HostCmd_CMD_802_11_REASSOCIATE        0x0025
#define HostCmd_CMD_802_11_DISASSOCIATE       0x0026
#define HostCmd_CMD_MAC_CONTROL               0x0028
#define HostCmd_CMD_802_11_AD_HOC_START       0x002b
#define HostCmd_CMD_802_11_AD_HOC_JOIN        0x002c

#define HostCmd_CMD_802_11_QUERY_TKIP_REPLY_CNTRS  0x002e
#define HostCmd_CMD_802_11_ENABLE_RSN              0x002f
#define HostCmd_CMD_802_11_PAIRWISE_TSC       0x0036
#define HostCmd_CMD_802_11_GROUP_TSC          0x0037
#define HostCmd_CMD_802_11_KEY_MATERIAL       0x005e


#define HostCmd_CMD_802_11_SET_AFC            0x003c
#define HostCmd_CMD_802_11_GET_AFC            0x003d

#define HostCmd_CMD_802_11_AD_HOC_STOP        0x0040


#define HostCmd_CMD_802_11_BEACON_STOP        0x0049

#define HostCmd_CMD_802_11_MAC_ADDRESS        0x004D
#define HostCmd_CMD_802_11_EEPROM_ACCESS      0x0059



#define HostCmd_CMD_802_11_BAND_CONFIG        0x0058

#define HostCmd_CMD_802_11D_DOMAIN_INFO       0x005b



#define HostCmd_CMD_802_11_SLEEP_PARAMS          0x0066

#define HostCmd_CMD_802_11_INACTIVITY_TIMEOUT    0x0067

#define HostCmd_CMD_802_11_SLEEP_PERIOD          0x0068





#define HostCmd_CMD_802_11_TPC_CFG               0x0072
#define HostCmd_CMD_802_11_PWR_CFG               0x0073


#define HostCmd_CMD_802_11_LED_GPIO_CTRL         0x004e

#define HostCmd_CMD_802_11_SUBSCRIBE_EVENT       0x0075

#define HostCmd_CMD_802_11_RATE_ADAPT_RATESET    0x0076


#define HostCmd_CMD_802_11_TX_RATE_QUERY	0x007f


#define HostCmd_CMD_GET_TSF                      0x0080





/* For the IEEE Power Save */
#define HostCmd_SubCmd_Enter_PS               0x0030
#define HostCmd_SubCmd_Exit_PS                0x0031
#define HostCmd_SubCmd_Sleep_Confirmed        0x0034
#define HostCmd_SubCmd_Full_PowerDown         0x0035
#define HostCmd_SubCmd_Full_PowerUp           0x0036

/* Command RET code, MSB is set to 1 */
#define HostCmd_RET_NONE                      0x8000
#define HostCmd_RET_HW_SPEC_INFO              0x8003
#define HostCmd_RET_EEPROM_UPDATE             0x8004
#define HostCmd_RET_802_11_RESET              0x8005
#define HostCmd_RET_802_11_SCAN               0x8006
#define HostCmd_RET_802_11_GET_LOG            0x800b
#define HostCmd_RET_MAC_CONTROL               0x8028
#define HostCmd_RET_MAC_MULTICAST_ADR         0x8010
#define HostCmd_RET_802_11_AUTHENTICATE       0x8011
#define HostCmd_RET_802_11_DEAUTHENTICATE     0x8024
#define HostCmd_RET_802_11_ASSOCIATE          0x8012
#define HostCmd_RET_802_11_REASSOCIATE        0x8025
#define HostCmd_RET_802_11_DISASSOCIATE       0x8026
#define HostCmd_RET_802_11_SET_WEP            0x8013
#define HostCmd_RET_802_11_STAT               0x8014
#define HostCmd_RET_802_3_STAT                0x8015
#define HostCmd_RET_802_11_SNMP_MIB           0x8016
#define HostCmd_RET_MAC_REG_MAP               0x8017
#define HostCmd_RET_BBP_REG_MAP               0x8018
#define HostCmd_RET_RF_REG_MAP                0x8023
#define HostCmd_RET_MAC_REG_ACCESS            0x8019
#define HostCmd_RET_BBP_REG_ACCESS            0x801a
#define HostCmd_RET_RF_REG_ACCESS             0x801b
#define HostCmd_RET_802_11_RADIO_CONTROL      0x801c
#define HostCmd_RET_802_11_RF_CHANNEL         0x801d
#define HostCmd_RET_802_11_RSSI               0x801f
#define HostCmd_RET_802_11_RF_TX_POWER        0x801e
#define HostCmd_RET_802_11_RF_ANTENNA         0x8020
#define HostCmd_RET_802_11_PS_MODE            0x8021
#define HostCmd_RET_802_11_DATA_RATE          0x8022

#define HostCmd_RET_802_11_AD_HOC_START       0x802B
#define HostCmd_RET_802_11_AD_HOC_JOIN        0x802C

#define HostCmd_RET_802_11_QUERY_TKIP_REPLY_CNTRS  0x802e
#define HostCmd_RET_802_11_ENABLE_RSN              0x802f
#define HostCmd_RET_802_11_PAIRWISE_TSC       0x8036
#define HostCmd_RET_802_11_GROUP_TSC          0x8037
#define HostCmd_RET_802_11_KEY_MATERIAL       0x805e

#define HostCmd_ENABLE_RSN                    0x0001
#define HostCmd_DISABLE_RSN                   0x0000
#define TYPE_ANTENNA_DIVERSITY                0xffff

#define HostCmd_ACT_SET                       0x0001
#define HostCmd_ACT_GET                       0x0000

#define HostCmd_ACT_GET_AES                   (HostCmd_ACT_GET + 2)
#define HostCmd_ACT_SET_AES                   (HostCmd_ACT_SET + 2)
#define HostCmd_ACT_REMOVE_AES                (HostCmd_ACT_SET + 3)


#define HostCmd_RET_802_11_SET_AFC            0x803c
#define HostCmd_RET_802_11_GET_AFC            0x803d

#define HostCmd_RET_802_11_AD_HOC_STOP        0x8040


#define HostCmd_RET_802_11_BEACON_STOP        0x8049

#define HostCmd_RET_802_11_MAC_ADDRESS        0x804D
#define HostCmd_RET_802_11_EEPROM_ACCESS      0x8059



#define HostCmd_RET_802_11_BAND_CONFIG        0x8058

#define HostCmd_RET_802_11_SLEEP_PARAMS          0x8066

#define HostCmd_RET_802_11_INACTIVITY_TIMEOUT    0x8067

#define HostCmd_RET_802_11_SLEEP_PERIOD          0x8068

#define HostCmd_RET_802_11D_DOMAIN_INFO      (0x8000 |                  \
                                              HostCmd_CMD_802_11D_DOMAIN_INFO)





#define HostCmd_RET_802_11_TPC_CFG        (HostCmd_CMD_802_11_TPC_CFG | 0x8000)
#define HostCmd_RET_802_11_PWR_CFG        (HostCmd_CMD_802_11_PWR_CFG | 0x8000)

#define HostCmd_RET_802_11_LED_GPIO_CTRL     0x804e


#define HostCmd_RET_802_11_SUBSCRIBE_EVENT	(HostCmd_CMD_802_11_SUBSCRIBE_EVENT | 0x8000)

#define HostCmd_RET_802_11_RATE_ADAPT_RATESET	(HostCmd_CMD_802_11_RATE_ADAPT_RATESET | 0x8000)


#define HostCmd_RTE_802_11_TX_RATE_QUERY 	(HostCmd_CMD_802_11_TX_RATE_QUERY | 0x8000)

#define HostCmd_RET_GET_TSF             0x8080




/** General Result Code*/
/* OK */
#define HostCmd_RESULT_OK                    0x0000  
/* Genenral error */
#define HostCmd_RESULT_ERROR                 0x0001  
/* Command is not valid */
#define HostCmd_RESULT_NOT_SUPPORT           0x0002  
/* Command is pending */
#define HostCmd_RESULT_PENDING               0x0003  
/* System is busy (command ignored) */
#define HostCmd_RESULT_BUSY                  0x0004
/* Data buffer is not big enough */
#define HostCmd_RESULT_PARTIAL_DATA          0x0005

/* Definition of action or option for each command */

/* Define general purpose action */
#define HostCmd_ACT_GEN_READ                    0x0000
#define HostCmd_ACT_GEN_WRITE                   0x0001
#define HostCmd_ACT_GEN_GET                     0x0000
#define HostCmd_ACT_GEN_SET                     0x0001
#define HostCmd_ACT_GEN_REMOVE			0x0002
#define HostCmd_ACT_GEN_OFF                     0x0000
#define HostCmd_ACT_GEN_ON                      0x0001

/* Define action or option for HostCmd_CMD_802_11_AUTHENTICATE */
#define HostCmd_ACT_AUTHENTICATE                0x0001
#define HostCmd_ACT_DEAUTHENTICATE              0x0002

/* Define action or option for HostCmd_CMD_802_11_ASSOCIATE */
#define HostCmd_ACT_ASSOCIATE                   0x0001
#define HostCmd_ACT_DISASSOCIATE                0x0002
#define HostCmd_ACT_REASSOCIATE                 0x0003

#define HostCmd_CAPINFO_ESS                     0x0001
#define HostCmd_CAPINFO_IBSS                    0x0002
#define HostCmd_CAPINFO_CF_POLLABLE             0x0004
#define HostCmd_CAPINFO_CF_REQUEST              0x0008
#define HostCmd_CAPINFO_PRIVACY                 0x0010

/* Define action or option for HostCmd_CMD_802_11_SET_WEP */
#define HostCmd_ACT_ADD                         0x0002
#define HostCmd_ACT_REMOVE                      0x0004
#define HostCmd_ACT_USE_DEFAULT                 0x0008

#define HostCmd_TYPE_WEP_40_BIT                 0x0001
#define HostCmd_TYPE_WEP_104_BIT                0x0002

#define HostCmd_NUM_OF_WEP_KEYS                 4

#define HostCmd_WEP_KEY_INDEX_MASK              0x3fff

/* Define action or option for HostCmd_CMD_802_11_RESET */
#define HostCmd_ACT_NOT_REVERT_MIB              0x0001
#define HostCmd_ACT_REVERT_MIB                  0x0002
#define HostCmd_ACT_HALT                        0x0003

/* Define action or option for HostCmd_CMD_802_11_SCAN */
#define HostCmd_BSS_TYPE_BSS                    0x0001
#define HostCmd_BSS_TYPE_IBSS                   0x0002
#define HostCmd_BSS_TYPE_ANY                    0x0003

/* Define action or option for HostCmd_CMD_802_11_SCAN */
#define HostCmd_SCAN_TYPE_ACTIVE                0x0000
#define HostCmd_SCAN_TYPE_PASSIVE               0x0001

#define HostCmd_SCAN_802_11_B_CHANNELS          11

#define HostCmd_SCAN_MIN_CH_TIME                6


#define HostCmd_SCAN_MAX_CH_TIME                100

#define HostCmd_SCAN_RADIO_TYPE_BG		0
#define HostCmd_SCAN_RADIO_TYPE_A		1
#define HostCmd_SCAN_PASSIVE_MAX_CH_TIME        100

#define HostCmd_SCAN_PROBE_DELAY_TIME           0

/* Define action or option for HostCmd_CMD_MAC_CONTROL */
#define HostCmd_ACT_MAC_RX_ON                   0x0001
#define HostCmd_ACT_MAC_TX_ON                   0x0002
#define HostCmd_ACT_MAC_LOOPBACK_ON             0x0004
#define HostCmd_ACT_MAC_WEP_ENABLE              0x0008
#define HostCmd_ACT_MAC_INT_ENABLE              0x0010
#define HostCmd_ACT_MAC_MULTICAST_ENABLE        0x0020
#define HostCmd_ACT_MAC_BROADCAST_ENABLE        0x0040
#define HostCmd_ACT_MAC_PROMISCUOUS_ENABLE      0x0080
#define HostCmd_ACT_MAC_ALL_MULTICAST_ENABLE    0x0100
#define HostCmd_ACT_MAC_STRICT_PROTECTION_ENABLE  0x0400
/* Define action or option or constant for HostCmd_CMD_MAC_MULTICAST_ADR */
#define HostCmd_SIZE_MAC_ADR                    6
#define HostCmd_MAX_MCAST_ADRS                  32

/* Define action or option for HostCmd_CMD_802_11_SNMP_MIB */
/* Boolean */
#define HostCmd_TYPE_MIB_FLD_BOOLEAN            0x0001  
/* Integer */
#define HostCmd_TYPE_MIB_FLD_INTEGER            0x0002 
/* Counter */
#define HostCmd_TYPE_MIB_FLD_COUNTER            0x0003  
/* Octet string */
#define HostCmd_TYPE_MIB_FLD_OCT_STR            0x0004 
/* String */
#define HostCmd_TYPE_MIB_FLD_DISPLAY_STR        0x0005  
/* MAC address */
#define HostCmd_TYPE_MIB_FLD_MAC_ADR            0x0006  
/* IP address */
#define HostCmd_TYPE_MIB_FLD_IP_ADR             0x0007  
/* WEP */
#define HostCmd_TYPE_MIB_FLD_WEP                0x0008 

/* Define action or option for HostCmd_CMD_802_11_RADIO_CONTROL */
#define HostCmd_TYPE_AUTO_PREAMBLE              0x0001
#define HostCmd_TYPE_SHORT_PREAMBLE             0x0002
#define HostCmd_TYPE_LONG_PREAMBLE              0x0003

#define TURN_ON_RF                              0x01
#define RADIO_ON                                0x01
#define RADIO_OFF                               0x00

#define SET_AUTO_PREAMBLE                       0x05
#define SET_SHORT_PREAMBLE                      0x03
#define SET_LONG_PREAMBLE                       0x01

/* Define action or option for CMD_802_11_RF_CHANNEL */
#define HostCmd_OPT_802_11_RF_CHANNEL_GET       0x00
#define HostCmd_OPT_802_11_RF_CHANNEL_SET       0x01

/* Define action or option for HostCmd_CMD_802_11_RF_TX_POWER */
#define HostCmd_ACT_TX_POWER_OPT_GET            0x0000
#define HostCmd_ACT_TX_POWER_OPT_SET_HIGH       0x8007
#define HostCmd_ACT_TX_POWER_OPT_SET_MID        0x8004
#define HostCmd_ACT_TX_POWER_OPT_SET_LOW        0x8000

#define HostCmd_ACT_TX_POWER_INDEX_HIGH         0x0007
#define HostCmd_ACT_TX_POWER_INDEX_MID          0x0004
#define HostCmd_ACT_TX_POWER_INDEX_LOW          0x0000

/* Define action or option for HostCmd_CMD_802_11_DATA_RATE */
#define HostCmd_ACT_SET_TX_AUTO                 0x0000
#define HostCmd_ACT_SET_TX_FIX_RATE             0x0001
#define HostCmd_ACT_GET_TX_RATE                 0x0002

#define HostCmd_ACT_SET_RX                      0x0001
#define HostCmd_ACT_SET_TX                      0x0002
#define HostCmd_ACT_SET_BOTH                    0x0003
#define HostCmd_ACT_GET_RX                      0x0004
#define HostCmd_ACT_GET_TX                      0x0008
#define HostCmd_ACT_GET_BOTH                    0x000c

/* Define action or option for HostCmd_CMD_802_11_PS_MODE */
#define HostCmd_TYPE_CAM                        0x0000
#define HostCmd_TYPE_MAX_PSP                    0x0001
#define HostCmd_TYPE_FAST_PSP                   0x0002

/** Card Event definition */
#define MACREG_INT_CODE_TX_PPA_FREE             0x00000000
#define MACREG_INT_CODE_TX_DMA_DONE             0x00000001
#define MACREG_INT_CODE_LINK_LOSE_W_SCAN        0x00000002
#define MACREG_INT_CODE_LINK_LOSE_NO_SCAN       0x00000003
#define MACREG_INT_CODE_LINK_SENSED             0x00000004
#define MACREG_INT_CODE_CMD_FINISHED            0x00000005
#define MACREG_INT_CODE_MIB_CHANGED             0x00000006
#define MACREG_INT_CODE_INIT_DONE               0x00000007
#define MACREG_INT_CODE_DEAUTHENTICATED         0x00000008
#define MACREG_INT_CODE_DISASSOCIATED           0x00000009
#define MACREG_INT_CODE_PS_AWAKE                0x0000000a
#define MACREG_INT_CODE_PS_SLEEP                0x0000000b
#define MACREG_INT_CODE_MIC_ERR_MULTICAST       0x0000000d
#define MACREG_INT_CODE_MIC_ERR_UNICAST         0x0000000e
#define MACREG_INT_CODE_WM_AWAKE                0x0000000f
#define MACREG_INT_CODE_ADHOC_BCN_LOST          0x00000011
#define MACREG_INT_CODE_RSSI_LOW		0x00000019 
#define MACREG_INT_CODE_SNR_LOW			0x0000001a 
#define MACREG_INT_CODE_MAX_FAIL		0x0000001b 
#define MACREG_INT_CODE_RSSI_HIGH		0x0000001c 
#define MACREG_INT_CODE_SNR_HIGH		0x0000001d 


#endif /* _HOST_H_ */
