/* @file hostcmd.h
 * 
 * @brief This file contains the function prototypes, data structure 
 * and defines for all the host/station commands
 *
 * (c) Copyright  2003-2006, Marvell International Ltd. 
 * All Rights Reserved
 *
 * This software file (the "File") is distributed by Marvell International 
 * Ltd. under the terms of the GNU General Public License Version 2, June 1991 
 * (the "License").  You may use, redistribute and/or modify this File in 
 * accordance with the terms and conditions of the License, a copy of which 
 * is available along with the File in the license.txt file or by writing to 
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
 *
 * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE 
 * ARE EXPRESSLY DISCLAIMED.  The License provides additional details about 
 * this warranty disclaimer.
 *
 */
/********************************************************
Change log:
	10/11/05: Add Doxygen format comments
	01/11/06: Update association struct to reflect IEEE passthrough response
		  Conditionalize new scan/join structures
	04/10/06: Add hostcmd generic API and power_adapt_cfg_ext command
	04/18/06: Remove old Subscrive Event and add new Subscribe Event
		  implementation through generic hostcmd API
	
********************************************************/

#ifndef __HOSTCMD__H
#define __HOSTCMD__H

/* 802.11-related definitions */

/* TxPD descriptor */
struct TxPD {
	/* Current Tx packet status */
	u32 TxStatus;
	/* Tx Control */
	u32 TxControl;
	u32 TxPacketLocation;
	/* Tx packet length */
	u16 TxPacketLength;
	/* First 2 byte of destination MAC address */
	u8 TxDestAddrHigh[2];
	/* Last 4 byte of destination MAC address */
	u8 TxDestAddrLow[4];
	/* Pkt Priority */
	u8 Priority;
	/* Pkt Trasnit Power control*/
	u8 PowerMgmt;
	/* Amount of time the packet has been queued in the driver (units = 2ms)*/
	u8 PktDelay_2ms;
	/* Reserved */
	u8 Reserved1;
};

/* RxPD Descriptor */
struct RxPD {
	/* Current Rx packet status */
	u16 Status;

	/* SNR */
	u8 SNR;

	/* Tx Control */
	u8 RxControl;

	/* Pkt Length */
	u16 PktLen;

	/* Noise Floor */
	u8 NF;

	/* Rx Packet Rate */
	u8 RxRate;

	/* Pkt addr*/
	u32 PktPtr;

	/* Next Rx RxPD addr */
	u32 NextRxPDPtr;

	/* Pkt Priority */
	u8 Priority;
	u8 Reserved[3];
};

#if defined(__KERNEL__)

/* CmdCtrlNode */
struct CmdCtrlNode {
	/* CMD link list */
	struct list_head list;

	u32 Status;

	/* CMD ID */
	u32 cmd_oid;

	/*CMD wait option: wait for finish or no wait */
	u16 wait_option;

	/* command parameter */
	void *pdata_buf;

	/*command data */
	u8 *BufVirtualAddr;

	u16 CmdFlags;

	/* wait queue */
	u16 CmdWaitQWoken;
	wait_queue_head_t cmdwait_q;
} __attribute__ ((packed));

#endif

/* MRVL_WEP_KEY */
struct MRVL_WEP_KEY {
	u32 Length;
	u32 KeyIndex;
	u32 KeyLength;
	u8 KeyMaterial[MRVL_KEY_BUFFER_SIZE_IN_BYTE];
};

/* WLAN_802_11_KEY */
struct WLAN_802_11_KEY {
	u32 Length;
	u32 KeyIndex;
	u32 KeyLength;
	u8 BSSID[ETH_ALEN];
	unsigned long long KeyRSC;
	u8 KeyMaterial[MRVL_MAX_KEY_WPA_KEY_LENGTH];
} __attribute__ ((packed));

/* MRVL_WPA_KEY */
struct MRVL_WPA_KEY {
	u32 KeyIndex;
	u32 KeyLength;
	u32 KeyRSC;
	u8 KeyMaterial[MRVL_MAX_KEY_WPA_KEY_LENGTH];
};

/* MRVL_WLAN_WPA_KEY */
#if 0
// unused at the moment
struct MRVL_WLAN_WPA_KEY {
	u8 EncryptionKey[16];
	u8 MICKey1[8];
	u8 MICKey2[8];
};
#endif

/* IE_WPA */
struct IE_WPA {
	u8 Elementid;
	u8 Len;
	u8 oui[4];
	u16 version;
};

/* WLAN_802_11_WEP */
#if 0
// unused at the moment
struct WLAN_802_11_WEP {
	/* Length of this structure */
	u32 Length;

	/* 0 is the per-client key, 1-N are the global keys */
	u32 KeyIndex;

	/* length of key in bytes */
	u32 KeyLength;

	/* variable length depending on above field */
	u8 KeyMaterial[1];
} __attribute__ ((packed));
#endif

/* WLAN_802_11_SSID */
struct WLAN_802_11_SSID {
	/* SSID Length */
	u32 SsidLength;

	/* SSID information field */
	u8 Ssid[WLAN_MAX_SSID_LENGTH];
};

struct WPA_SUPPLICANT {
	u8 Wpa_ie[256];
	u8 Wpa_ie_len;
};

/* wlan_offset_value */
struct wlan_offset_value {
	u32 offset;
	u32 value;
};

/* WLAN_802_11_FIXED_IEs */
struct WLAN_802_11_FIXED_IEs {
	u8 Timestamp[8];
	u16 BeaconInterval;
	u16 Capabilities;
};

/* WLAN_802_11_VARIABLE_IEs */
struct WLAN_802_11_VARIABLE_IEs {
	u8 ElementID;
	u8 Length;
	u8 data[1];
};

/* WLAN_802_11_AI_RESFI */
struct WLAN_802_11_AI_RESFI {
	u16 Capabilities;
	u16 StatusCode;
	u16 AssociationId;
};

/* WLAN_802_11_AI_REQFI */
struct WLAN_802_11_AI_REQFI {
	u16 Capabilities;
	u16 ListenInterval;
	u8  CurrentAPAddress[ETH_ALEN];
};

/* Define general data structure */
/* HostCmd_DS_GEN */
struct HostCmd_DS_GEN {
	u16 Command;
	u16 Size;
	u16 SeqNum;
	u16 Result;
};

#define S_DS_GEN sizeof(struct HostCmd_DS_GEN)
/*
 * Define data structure for HostCmd_CMD_GET_HW_SPEC
 * This structure defines the response for the GET_HW_SPEC command
 */
/* HostCmd_DS_GET_HW_SPEC */
struct HostCmd_DS_GET_HW_SPEC {
	/* HW Interface version number */
	u16 HWIfVersion;

	/* HW version number */
	u16 Version;

	/* Max number of TxPD FW can handle */
	u16 NumOfTxPD;

	/* Max no of Multicast address */
	u16 NumOfMCastAdr;

	/* MAC address */
	u8 PermanentAddr[6];

	/* Region Code */
	u16 RegionCode;

	/* Number of antenna used */
	u16 NumberOfAntenna;

	/* FW release number, example 0x1234=1.2.3.4 */
	u32 FWReleaseNumber;

	/* Base Address of TxPD queue */
	u32 WcbBase;
	/* Read Pointer of RxPd queue */
	u32 RxPdRdPtr;

	/* Write Pointer of RxPd queue */
	u32 RxPdWrPtr;

	/*FW/HW Capability */
	u32 fwCapInfo;
} __attribute__ ((packed));

/* HostCmd_CMD_EEPROM_UPDATE */
struct HostCmd_DS_EEPROM_UPDATE {
	u16 Action;
	u32 Value;
} __attribute__ ((packed));

/* HostCmd_CMD_802_11_RESET */
struct HostCmd_DS_802_11_RESET {
	u16 Action;
};

struct HostCmd_DS_802_11_SUBSCRIBE_EVENT {
	u16 Action;
	u16 Events;
};

/* 
 * This scan handle Country Information IE(802.11d compliant) 
 * Define data structure for HostCmd_CMD_802_11_SCAN 
 */
/* HostCmd_DS_802_11_SCAN */
struct HostCmd_DS_802_11_SCAN {
	u8 BSSType;
	u8 BSSID[ETH_ALEN];
	u8 TlvBuffer[1];
#if 0
	MrvlIEtypes_SsIdParamSet_t SsIdParamSet; 
	MrvlIEtypes_ChanListParamSet_t ChanListParamSet;
	MrvlIEtypes_RatesParamSet_t OpRateSet; 
#endif
};

struct HostCmd_DS_802_11_SCAN_RSP {
	u16 BSSDescriptSize;
	u8 NumberOfSets;
	u8 BssDescAndTlvBuffer[1];
};

/* HostCmd_CMD_802_11_GET_LOG */
struct HostCmd_DS_802_11_GET_LOG {
	u32 mcasttxframe;
	u32 failed;
	u32 retry;
	u32 multiretry;
	u32 framedup;
	u32 rtssuccess;
	u32 rtsfailure;
	u32 ackfailure;
	u32 rxfrag;
	u32 mcastrxframe;
	u32 fcserror;
	u32 txframe;
	u32 wepundecryptable;
};

/* HostCmd_CMD_MAC_CONTROL */
struct HostCmd_DS_MAC_CONTROL {
	u16 Action;
	u16 Reserved;
};

/* HostCmd_CMD_MAC_MULTICAST_ADR */
struct HostCmd_DS_MAC_MULTICAST_ADR {
	u16 Action;
	u16 NumOfAdrs;
	u8 MACList[MRVDRV_ETH_ADDR_LEN * MRVDRV_MAX_MULTICAST_LIST_SIZE];
};

/* HostCmd_CMD_802_11_AUTHENTICATE */
struct HostCmd_DS_802_11_AUTHENTICATE {
	u8 MacAddr[ETH_ALEN];
	u8 AuthType;
	u8 Reserved[10];
};

/* HostCmd_RET_802_11_AUTHENTICATE */
struct HostCmd_DS_802_11_AUTHENTICATE_RSP {
	u8 MacAddr[6];
	u8 AuthType;
	u8 AuthStatus;
};

/* HostCmd_CMD_802_11_DEAUTHENTICATE */
struct HostCmd_DS_802_11_DEAUTHENTICATE {
	u8 MacAddr[6];
	u16 ReasonCode;
};

/* HostCmd_DS_802_11_ASSOCIATE */
struct HostCmd_DS_802_11_ASSOCIATE {
	u8 PeerStaAddr[6];
	IEEEtypes_CapInfo_t CapInfo;
	u16 ListenInterval;
	u16 BcnPeriod;
	u8 DtimPeriod;

#if 0
	MrvlIEtypes_SsIdParamSet_t SsIdParamSet;
	MrvlIEtypes_PhyParamSet_t PhyParamSet;
	MrvlIEtypes_SsParamSet_t SsParamSet;
	MrvlIEtypes_RatesParamSet_t RatesParamSet;
#endif
} __attribute__ ((packed));

/* HostCmd_CMD_802_11_DISASSOCIATE */
struct HostCmd_DS_802_11_DISASSOCIATE {
	u8 DestMacAddr[6];
	u16 ReasonCode;
};

/* HostCmd_RET_802_11_ASSOCIATE */
struct HostCmd_DS_802_11_ASSOCIATE_RSP {
	IEEEtypes_AssocRsp_t assocRsp;
} __attribute__ ((packed));

/* HostCmd_RET_802_11_AD_HOC_JOIN */
struct HostCmd_DS_802_11_AD_HOC_RESULT {
	u8 PAD[3];
	u8 BSSID[MRVDRV_ETH_ADDR_LEN];
};

/* HostCmd_CMD_802_11_SET_WEP */
struct HostCmd_DS_802_11_SET_WEP {
	/* ACT_ADD, ACT_REMOVE or ACT_ENABLE */
	u16 Action;

	/* Key Index selected for Tx */
	u16 KeyIndex;

	/* 40, 128bit or TXWEP */
	u8 WEPTypeForKey1;

	u8 WEPTypeForKey2;
	u8 WEPTypeForKey3;
	u8 WEPTypeForKey4;
	u8 WEP1[16];
	u8 WEP2[16];
	u8 WEP3[16];
	u8 WEP4[16];
};

/* HostCmd_CMD_802_3_GET_STAT */
struct HostCmd_DS_802_3_GET_STAT {
	u32 XmitOK;
	u32 RcvOK;
	u32 XmitError;
	u32 RcvError;
	u32 RcvNoBuffer;
	u32 RcvCRCError;
};

/* HostCmd_CMD_802_11_GET_STAT */
struct HostCmd_DS_802_11_GET_STAT {
	u32 TXFragmentCnt;
	u32 MCastTXFrameCnt;
	u32 FailedCnt;
	u32 RetryCnt;
	u32 MultipleRetryCnt;
	u32 RTSSuccessCnt;
	u32 RTSFailureCnt;
	u32 ACKFailureCnt;
	u32 FrameDuplicateCnt;
	u32 RXFragmentCnt;
	u32 MCastRXFrameCnt;
	u32 FCSErrorCnt;
	u32 BCastTXFrameCnt;
	u32 BCastRXFrameCnt;
	u32 TXBeacon;
	u32 RXBeacon;
	u32 WEPUndecryptable;
};

/* HostCmd_DS_802_11_AD_HOC_STOP */
/* wtf?  -- pjones */
struct HostCmd_DS_802_11_AD_HOC_STOP {

};

/* HostCmd_DS_802_11_BEACON_STOP */
/* wtf?  -- pjones */
struct HostCmd_DS_802_11_BEACON_STOP {

};

/* HostCmd_CMD_802_11_SNMP_MIB */
struct HostCmd_DS_802_11_SNMP_MIB {
	u16 QueryType;
	u16 OID;
	u16 BufSize;
	u8 Value[128];
};

/* HostCmd_CMD_MAC_REG_MAP */
struct HostCmd_DS_MAC_REG_MAP {
	u16 BufferSize;
	u8 RegMap[128];
	u16 Reserved;
};

/* HostCmd_CMD_BBP_REG_MAP */
struct HostCmd_DS_BBP_REG_MAP {
	u16 BufferSize;
	u8 RegMap[128];
	u16 Reserved;
};

/* HostCmd_CMD_RF_REG_MAP */
struct HostCmd_DS_RF_REG_MAP {
	u16 BufferSize;
	u8 RegMap[64];
	u16 Reserved;
};

/* HostCmd_CMD_MAC_REG_ACCESS */
struct HostCmd_DS_MAC_REG_ACCESS {
	u16 Action;
	u16 Offset;
	u32 Value;
};

/* HostCmd_CMD_BBP_REG_ACCESS */
struct HostCmd_DS_BBP_REG_ACCESS {
	u16 Action;
	u16 Offset;
	u8 Value;
	u8 Reserved[3];
};

/* HostCmd_CMD_RF_REG_ACCESS */
struct HostCmd_DS_RF_REG_ACCESS {
	u16 Action;
	u16 Offset;
	u8 Value;
	u8 Reserved[3];
};

/* HostCmd_CMD_802_11_RADIO_CONTROL */
struct HostCmd_DS_802_11_RADIO_CONTROL {
	u16 Action;
	u16 Control;
};

/* HostCmd_DS_802_11_SLEEP_PARAMS */
struct HostCmd_DS_802_11_SLEEP_PARAMS {
	/* ACT_GET/ACT_SET */
	u16 Action;

	/* Sleep clock error in ppm */
	u16 Error;

	/* Wakeup offset in usec */
	u16 Offset;

	/* Clock stabilization time in usec */
	u16 StableTime;

	/* Control periodic calibration */
	u8 CalControl;

	/* Control the use of external sleep clock */
	u8 ExternalSleepClk;

	/* Reserved field, should be set to zero */
	u16 Reserved;
};

/* HostCmd_DS_802_11_SLEEP_PERIOD */
struct HostCmd_DS_802_11_SLEEP_PERIOD {
	/* ACT_GET/ACT_SET */
	u16 Action;

	/* Sleep Period in msec */
	u16 Period;
};

/* HostCmd_DS_802_11_INACTIVITY_TIMEOUT */
struct HostCmd_DS_802_11_INACTIVITY_TIMEOUT {
	/* ACT_GET/ACT_SET */
	u16 Action;

	/* Inactivity timeout in msec */
	u16 Timeout;
};

/* HostCmd_CMD_802_11_RF_CHANNEL */
struct HostCmd_DS_802_11_RF_CHANNEL {
	u16 Action;
	u16 CurrentChannel;
	u16 RFType;
	u16 Reserved;
	u8 ChannelList[32];
};

/* HostCmd_CMD_802_11_RSSI */
struct HostCmd_DS_802_11_RSSI {
	/* weighting factor */
	u16 N;

	u16 Reserved_0;
	u16 Reserved_1;
	u16 Reserved_2;
};

/* HostCmd_DS_802_11_RSSI_RSP */
struct HostCmd_DS_802_11_RSSI_RSP {
	u16 SNR;
	u16 NoiseFloor;
	u16 AvgSNR;
	u16 AvgNoiseFloor;
};

/* HostCmd_DS_802_11_MAC_ADDRESS */
struct HostCmd_DS_802_11_MAC_ADDRESS {
	u16 Action;
	u8 MacAdd[ETH_ALEN];
};

/* HostCmd_CMD_802_11_RF_TX_POWER */
struct HostCmd_DS_802_11_RF_TX_POWER {
	u16 Action;
	u16 CurrentLevel;
};

/* HostCmd_CMD_802_11_RF_ANTENNA */
struct HostCmd_DS_802_11_RF_ANTENNA {
	u16 Action;

	/* Number of antennas or 0xffff(diversity) */
	u16 AntennaMode;

};

/* HostCmd_CMD_802_11_PS_MODE */
struct HostCmd_DS_802_11_PS_MODE {
	u16 Action;
	u16 NullPktInterval;
	u16 MultipleDtim;
	u16 Reserved;
	u16 LocalListenInterval;
};

/* PS_CMD_ConfirmSleep */
struct PS_CMD_ConfirmSleep {
	u16 Command;
	u16 Size;
	u16 SeqNum;
	u16 Result;

	u16 Action;
	u16 Reserved1;
	u16 MultipleDtim;
	u16 Reserved;
	u16 LocalListenInterval;
};

/* HostCmd_CMD_802_11_DATA_RATE */
struct HostCmd_DS_802_11_DATA_RATE {
	u16 Action;
	u16 Reserverd;
	u8 DataRate[HOSTCMD_SUPPORTED_RATES];
};

/* HostCmd_DS_802_11_RATE_ADAPT_RATESET */
struct HostCmd_DS_802_11_RATE_ADAPT_RATESET {
	u16 Action;
	u16 EnableHwAuto;
	u16 Bitmap;
};

/* HostCmd_DS_802_11_AD_HOC_START*/
struct HostCmd_DS_802_11_AD_HOC_START {
	u8 SSID[MRVDRV_MAX_SSID_LENGTH];
	u8 BSSType;
	u16 BeaconPeriod;
	u8 DTIMPeriod;
	IEEEtypes_SsParamSet_t SsParamSet;
	IEEEtypes_PhyParamSet_t PhyParamSet;
	u16 ProbeDelay;
	IEEEtypes_CapInfo_t Cap;
	u8 DataRate[HOSTCMD_SUPPORTED_RATES];
	u8 tlv_memory_size_pad[100];
} __attribute__ ((packed));

/* AdHoc_BssDesc_t */
struct AdHoc_BssDesc {
	u8 BSSID[6];
	u8 SSID[32];
	u8 BSSType;
	u16 BeaconPeriod;
	u8 DTIMPeriod;
	u8 TimeStamp[8];
	u8 LocalTime[8];
	IEEEtypes_PhyParamSet_t PhyParamSet;
	IEEEtypes_SsParamSet_t SsParamSet;
	IEEEtypes_CapInfo_t Cap;
	u8 DataRates[HOSTCMD_SUPPORTED_RATES];

	/* DO NOT ADD ANY FIELDS TO THIS STRUCTURE. It is used below in the
	 * Adhoc join command and will cause a binary layout mismatch with 
	 * the firmware 
	 */
} __attribute__ ((packed));

/* HostCmd_DS_802_11_AD_HOC_JOIN */
struct HostCmd_DS_802_11_AD_HOC_JOIN {
	struct AdHoc_BssDesc BssDescriptor;
	u16 FailTimeOut;
	u16 ProbeDelay;

} __attribute__ ((packed));

/* HostCmd_DS_802_11_ENABLE_RSN */
struct HostCmd_DS_802_11_ENABLE_RSN {
	u16 Action;
	u16 Enable;
};

/* HostCmd_DS_802_11_QUERY_TKIP_REPLY_CNTRS */
struct HostCmd_DS_802_11_QUERY_TKIP_REPLY_CNTRS {
	u16 CmdCode;
	u16 Size;
	u16 SeqNum;
	u16 Result;
	u32 NumTkipCntrs;
};

/* HostCmd_DS_802_11_PAIRWISE_TSC */
struct HostCmd_DS_802_11_PAIRWISE_TSC {
	u16 CmdCode;
	u16 Size;
	u16 SeqNum;
	u16 Result;
	u16 Action;
	u32 Txlv32;
	u16 Txlv16;
};

/* HostCmd_DS_802_11_GROUP_TSC */
struct HostCmd_DS_802_11_GROUP_TSC {
	u16 CmdCode;
	u16 Size;
	u16 SeqNum;
	u16 Result;
	u16 Action;
	u32 Txlv32;
	u16 Txlv16;
};

typedef union _KeyInfo_WEP_t {
	u8 Reserved;

	/* bits 1-4: Specifies the index of key */
	u8 WepKeyIndex;

	/* bit 0: Specifies that this key is 
	 * to be used as the default for TX data packets */
	u8 isWepDefaultKey;
} KeyInfo_WEP_t;

typedef union _KeyInfo_TKIP_t {
	u8 Reserved;

	/* bit 2: Specifies that this key is 
	 * enabled and valid to use */
	u8 isKeyEnabled;

	/* bit 1: Specifies that this key is
	 * to be used as the unicast key */
	u8 isUnicastKey;

	/* bit 0: Specifies that this key is 
	 * to be used as the multicast key */
	u8 isMulticastKey;
} KeyInfo_TKIP_t;

typedef union _KeyInfo_AES_t {
	u8 Reserved;

	/* bit 2: Specifies that this key is
	 * enabled and valid to use */
	u8 isKeyEnabled;

	/* bit 1: Specifies that this key is
	 * to be used as the unicast key */
	u8 isUnicastKey;

	/* bit 0: Specifies that this key is 
	 * to be used as the multicast key */
	u8 isMulticastKey;
} KeyInfo_AES_t;

/* KeyMaterial_TKIP_t */
struct KeyMaterial_TKIP_t {
	/* TKIP encryption/decryption key */
	u8 TkipKey[16];

	/* TKIP TX MIC Key */
	u8 TkipTxMicKey[16];

	/* TKIP RX MIC Key */
	u8 TkipRxMicKey[16];
};

/* KeyMaterial_AES_t */
struct KeyMaterial_AES_t {
	/* AES encryption/decryption key */
	u8 AesKey[16];
};

/* MrvlIEtype_KeyParamSet_t */
struct MrvlIEtype_KeyParamSet {
	/* Type ID */
	u16 Type;

	/* Length of Payload */
	u16 Length;

	/* Type of Key: WEP=0, TKIP=1, AES=2 */
	u16 KeyTypeId;

	/* Key Control Info specific to a KeyTypeId */
	u16 KeyInfo;

	/* Length of key */
	u16 KeyLen;

	/* Key material of size KeyLen */
	u8 Key[32];
};

/* HostCmd_DS_802_11_KEY_MATERIAL */
struct HostCmd_DS_802_11_KEY_MATERIAL {
	u16 Action;
	struct MrvlIEtype_KeyParamSet KeyParamSet;
} __attribute__ ((packed));

/* HostCmd_DS_802_11_EEPROM_ACCESS */
struct HostCmd_DS_802_11_EEPROM_ACCESS {
	u16 Action;

	/* multiple 4 */
	u16 Offset;
	u16 ByteCount;
	u8 Value;
} __attribute__ ((packed));

/* HostCmd_DS_802_11_TPC_CFG */
struct HostCmd_DS_802_11_TPC_CFG {
	u16 Action;
	u8 Enable;
	s8 P0;
	s8 P1;
	s8 P2;
	u8 UseSNR;
} __attribute__ ((packed));

/* HostCmd_DS_802_11_LED_CTRL */
struct HostCmd_DS_802_11_LED_CTRL {
	u16 Action;
	u16 NumLed;
	u8 data[256];
} __attribute__ ((packed));

/** HostCmd_DS_802_11_PWR_CFG */
struct HostCmd_DS_802_11_PWR_CFG {
	u16 Action;
	u8 Enable;
	s8 PA_P0;
	s8 PA_P1;
	s8 PA_P2;
} __attribute__ ((packed));

/* HostCmd_DS_802_11_AFC */
struct HostCmd_DS_802_11_AFC {
	u16 afc_auto;
	union {
		struct {
			u16 threshold;
			u16 period;
		} auto_mode;
		struct {
			s16 timing_offset;
			s16 carrier_offset;
		} manual_mode;
	} b;
} __attribute__ ((packed));

#define afc_data b.data
#define afc_thre b.auto_mode.threshold
#define afc_period b.auto_mode.period
#define afc_toff b.manual_mode.timing_offset
#define afc_foff b.manual_mode.carrier_offset

struct HostCmd_TX_RATE_QUERY {
	u16 TxRate;
} __attribute__ ((packed));

struct HostCmd_DS_GET_TSF {
	u64 TsfValue;
} __attribute__ ((packed));

/* HostCmd_DS_COMMAND*/
struct HostCmd_DS_COMMAND {
	/* Command Header */
	u16 Command;
	u16 Size;
	u16 SeqNum;
	u16 Result;

	/* Command Body */
	union {
		struct HostCmd_DS_GET_HW_SPEC hwspec;
		struct HostCmd_DS_802_11_PS_MODE psmode;
		struct HostCmd_DS_802_11_SCAN scan;
		struct HostCmd_DS_802_11_SCAN_RSP scanresp;
		struct HostCmd_DS_MAC_CONTROL macctrl;
		struct HostCmd_DS_802_11_ASSOCIATE associate;
		struct HostCmd_DS_802_11_ASSOCIATE_RSP associatersp;
		struct HostCmd_DS_802_11_DEAUTHENTICATE deauth;
		struct HostCmd_DS_802_11_SET_WEP wep;
		struct HostCmd_DS_802_11_AD_HOC_START ads;
		struct HostCmd_DS_802_11_RESET reset;
		struct HostCmd_DS_802_11_AD_HOC_RESULT result;
		struct HostCmd_DS_802_11_GET_LOG glog;
		struct HostCmd_DS_802_11_AUTHENTICATE auth;
		struct HostCmd_DS_802_11_AUTHENTICATE_RSP rauth;
		struct HostCmd_DS_802_11_GET_STAT gstat;
		struct HostCmd_DS_802_3_GET_STAT gstat_8023;
		struct HostCmd_DS_802_11_SNMP_MIB smib;
		struct HostCmd_DS_802_11_RF_TX_POWER txp;
		struct HostCmd_DS_802_11_RF_ANTENNA rant;
		struct HostCmd_DS_802_11_DATA_RATE drate;
		struct HostCmd_DS_802_11_RATE_ADAPT_RATESET rateset;
		struct HostCmd_DS_MAC_MULTICAST_ADR madr;
		struct HostCmd_DS_802_11_AD_HOC_JOIN adj;
		struct HostCmd_DS_802_11_RADIO_CONTROL radio;
		struct HostCmd_DS_802_11_RF_CHANNEL rfchannel;
		struct HostCmd_DS_802_11_RSSI rssi;
		struct HostCmd_DS_802_11_RSSI_RSP rssirsp;
		struct HostCmd_DS_802_11_DISASSOCIATE dassociate;
		struct HostCmd_DS_802_11_AD_HOC_STOP adhoc_stop;
		struct HostCmd_DS_802_11_MAC_ADDRESS macadd;
		struct HostCmd_DS_802_11_ENABLE_RSN enbrsn;
		struct HostCmd_DS_802_11_KEY_MATERIAL keymaterial;
		struct HostCmd_DS_MAC_REG_ACCESS macreg;
		struct HostCmd_DS_BBP_REG_ACCESS bbpreg;
		struct HostCmd_DS_RF_REG_ACCESS rfreg;
		struct HostCmd_DS_802_11_BEACON_STOP beacon_stop;
		struct HostCmd_DS_802_11_EEPROM_ACCESS rdeeprom;

		struct HostCmd_DS_802_11D_DOMAIN_INFO domaininfo;
		struct HostCmd_DS_802_11D_DOMAIN_INFO_RSP domaininforesp;

		struct HostCmd_DS_802_11_SLEEP_PARAMS sleep_params;
		struct HostCmd_DS_802_11_INACTIVITY_TIMEOUT inactivity_timeout;
		struct HostCmd_DS_802_11_SLEEP_PERIOD ps_sleeppd;
		struct HostCmd_DS_802_11_TPC_CFG tpccfg;
		struct HostCmd_DS_802_11_PWR_CFG pwrcfg;
		struct HostCmd_DS_802_11_AFC afc;
		struct HostCmd_DS_802_11_LED_CTRL ledgpio;

		struct HostCmd_TX_RATE_QUERY txrate;
		struct HostCmd_DS_GET_TSF gettsf;
	} params;
} __attribute__ ((packed));

#endif
