#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <asm/arch/hardware.h>
#include <asm/arch/pxa-regs.h>
#include <asm/irq.h>
#include <linux/sched.h>
#include <linux/signal.h>
#include <linux/irq.h>
#include <linux/interrupt.h>

static int __init geofft_start(void) {
	pxa_gpio_mode(82 | GPIO_OUT | GPIO_DFLT_HIGH); // RESET
	mdelay(500);
	GPCR(82) = GPIO_bit(82);
	mdelay(500);
	return 0;
}

static void __exit geofft_end(void) {
	set_irq_type(IRQ_GPIO(0), IRQT_NOEDGE);
}

module_init(geofft_start);
module_exit(geofft_end);
MODULE_LICENSE("GPL");
