#include "adc.h"

struct tsadc_platform_data {
	// Information on pen down gpio.
	int pen_irq;
	int pin_irq_falling;
	int pen_gpio;
	int (*ispendown)(void);

	// Details of touchscreen
	/* If you know resistance of TS panel, and really want to know 
	   "resistance of touch" (whatever that is), set this. In use by 
	   ts-adc. */
	int x_plate_ohms;
	/* Otherwise, of more interest is relative pressure of touch.
	   Use this to normalize standard stylus touch pressure value to
	   be in range TBD */
	int pressure_factor;
	/* If relative pressure goes below this value, consider stylus is
	   being lifted, and stop TS sampling. */
	int min_pressure;
	/* If, during measurement, two consecutive samples will differ by 
	   more than this value, the whole measurement will be discarded. */
	int max_jitter;

	// ADC chip info.
	int max_sense;
	char *x_pin, *y_pin, *z1_pin, *z2_pin;
};
