/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.Location;

public class SequencesAsGFF {
    private FeatureFilter filter = FeatureFilter.all;
    private boolean recurse = false;

    public FeatureFilter getFeatureFilter() {
        return this.filter;
    }

    public void setFeatureFilter(FeatureFilter filter) {
        this.filter = filter;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    protected void doProcessSequence(Sequence seq, GFFDocumentHandler handler, String id) throws BioException, BioException {
        Iterator fi = seq.filter(this.getFeatureFilter(), this.getRecurse()).features();
        while (fi.hasNext()) {
            Feature f = (Feature)fi.next();
            SimpleGFFRecord record = new SimpleGFFRecord();
            record.setSeqName(id);
            record.setSource(f.getSource());
            record.setFeature(f.getType());
            Location loc = f.getLocation();
            record.setStart(loc.getMin());
            record.setEnd(loc.getMax());
            record.setScore(Double.NEGATIVE_INFINITY);
            record.setStrand(StrandedFeature.UNKNOWN);
            if (f instanceof StrandedFeature) {
                StrandedFeature sf = (StrandedFeature)f;
                if (sf.getStrand() == StrandedFeature.POSITIVE) {
                    record.setStrand(StrandedFeature.POSITIVE);
                } else if (sf.getStrand() == StrandedFeature.NEGATIVE) {
                    record.setStrand(StrandedFeature.NEGATIVE);
                }
            }
            record.setFrame(-1);
            Map fMap = f.getAnnotation().asMap();
            Iterator ki = fMap.keySet().iterator();
            while (ki.hasNext()) {
                ArrayList<Object> valueList;
                Object key = ki.next();
                Object value = fMap.get(key);
                String keyS = key.toString();
                if (value instanceof List) {
                    valueList = (ArrayList<Object>)value;
                } else {
                    valueList = new ArrayList<Object>();
                    valueList.add(value);
                }
                int i = 0;
                while (i < valueList.size()) {
                    Object o = valueList.get(i);
                    valueList.set(i, o.toString());
                    ++i;
                }
                fMap.put(keyS, valueList);
            }
            record.setGroupAttributes(fMap);
            record.setComment(null);
            handler.recordLine(record);
        }
    }

    public void processSequence(Sequence seq, GFFDocumentHandler handler) throws BioException, BioException {
        handler.startDocument(seq.getURN());
        this.doProcessSequence(seq, handler, seq.getName());
        handler.endDocument();
    }

    public void processDB(SequenceDB seqDB, GFFDocumentHandler handler) throws BioException, BioException {
        handler.startDocument("unknown:SequenceDB");
        Iterator i = seqDB.ids().iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            Sequence seq = seqDB.getSequence(id);
            this.doProcessSequence(seq, handler, id);
        }
        handler.endDocument();
    }
}

