/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.phred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;

public class PhredFormat
implements SequenceFormat,
Serializable {
    public static final String PROPERTY_DESCRIPTIONLINE = "description_line";
    private int lineWidth = 60;
    static /* synthetic */ Class class$org$biojava$bio$program$phred$PhredFormat;

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = this.lineWidth;
    }

    public boolean readSequence(BufferedReader reader, SymbolParser symParser, SeqIOListener siol) throws IllegalSymbolException, IOException, ParseException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature stream end");
        }
        if (!line.startsWith(">")) {
            throw new IOException("Stream does not appear to contain Phred formatted data: " + line);
        }
        siol.startSequence();
        String description = line.substring(1).trim();
        siol.addSequenceProperty(PROPERTY_DESCRIPTIONLINE, description);
        boolean seenEOF = this.readSequenceData(reader, symParser, siol);
        siol.endSequence();
        return !seenEOF;
    }

    private boolean readSequenceData(BufferedReader br, SymbolParser parser, SeqIOListener listener) throws IOException, IllegalSymbolException {
        char[] buffer = new char[256];
        StreamParser sparser = parser.parseStream(listener);
        boolean seenEOF = false;
        boolean reachedEnd = false;
        while (!reachedEnd) {
            br.mark(buffer.length);
            int bytesRead = br.read(buffer, 0, buffer.length);
            while (Character.isDigit(buffer[buffer.length - 1])) {
                br.reset();
                buffer = new char[buffer.length + 64];
                br.mark(buffer.length);
                bytesRead = br.read(buffer, 0, buffer.length);
            }
            if (bytesRead < 0) {
                reachedEnd = true;
                seenEOF = true;
                continue;
            }
            int parseStart = 0;
            int parseEnd = 0;
            while (!reachedEnd && parseStart < bytesRead && buffer[parseStart] != '>') {
                parseEnd = parseStart;
                while (parseEnd < bytesRead && !Character.isWhitespace(buffer[parseEnd])) {
                    ++parseEnd;
                }
                sparser.characters(buffer, parseStart, parseEnd - parseStart);
                parseStart = parseEnd + 1;
                while (parseStart < bytesRead && !Character.isDigit(buffer[parseStart]) && buffer[parseStart] != '>') {
                    ++parseStart;
                }
            }
            if (parseStart >= bytesRead || buffer[parseStart] != '>') continue;
            br.reset();
            if (br.skip(parseStart) != (long)parseStart) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            reachedEnd = true;
        }
        sparser.close();
        return seenEOF;
    }

    protected String describeSequence(Sequence seq) {
        String description = null;
        try {
            description = seq.getAnnotation().getProperty(PROPERTY_DESCRIPTIONLINE).toString();
        }
        catch (NoSuchElementException ex) {
            description = seq.getName();
        }
        return description;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        os.print(">");
        os.println(this.describeSequence(seq));
        StringBuffer line = new StringBuffer();
        int i = 1;
        boolean linesPrinted = true;
        while (i <= seq.length()) {
            int val = ((IntegerAlphabet.IntegerSymbol)seq.symbolAt(i)).intValue();
            String s = Integer.toString(val);
            if (line.length() + s.length() > this.lineWidth) {
                os.println(line.toString());
                line = new StringBuffer();
            }
            line.append(s + " ");
            ++i;
        }
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        String requestedFormat = new String(format);
        boolean found = false;
        String[] formats = this.getFormats().toArray(new String[0]);
        if (!found) {
            throw new IOException("Unable to write: an invalid file format '" + format + "' was requested");
        }
        this.writeSequence(seq, os);
    }

    public Set getFormats() {
        return (Set)SequenceFormat.FORMATS.get(this.getClass().getName());
    }

    public String getDefaultFormat() {
        return "Phred";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashSet<String> validFormats = new HashSet<String>();
        validFormats.add("Phred");
        SequenceFormat.FORMATS.put((class$org$biojava$bio$program$phred$PhredFormat == null ? (class$org$biojava$bio$program$phred$PhredFormat = PhredFormat.class$("org.biojava.bio.program.phred.PhredFormat")) : class$org$biojava$bio$program$phred$PhredFormat).getName(), validFormats);
    }
}

