/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.program.search.SearchContentHandler;
import org.biojava.bio.program.search.SearchParser;
import org.biojava.utils.ParserException;

public class FastaSearchParser
implements SearchParser {
    private static final int NODATA = 0;
    private static final int INHEADER = 1;
    private static final int INHIT = 2;
    private static final int INQUERY = 3;
    private static final int INSUBJECT = 4;
    private static final int INALIGN = 5;
    private static HashSet resultAnnoTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"mp_name", "mp_ver", "mp_argv", "mp_extrap", "mp_stats", "mp_KS", "pg_name", "pg_ver", "pg_optcut", "pg_cgap"}, new HashSet());
    private static HashSet resultSearchParmTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"pg_matrix", "pg_ktup", "pg_gap-pen"}, new HashSet());
    private static HashSet hitAnnoTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"fa_frame", "fa_initn", "fa_init1", "fa_opt", "fa_bits", "sw_score", "sw_ident", "sw_gident", "sw_overlap", "fa_ident", "fa_gident", "fa_overlap", "fa_score"}, new HashSet());
    private static HashSet hitDataTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"fa_expect", "fa_z-score"}, new HashSet());
    private int searchStatus = 0;
    private boolean searchParsed = false;
    private SearchContentHandler handler;
    private BufferedReader reader;
    private String line;
    private int lineNumber;
    StringBuffer querySeqTokens = new StringBuffer(1024);
    StringBuffer subjectSeqTokens = new StringBuffer(1024);
    StringBuffer matchTokens = new StringBuffer(1024);

    public void parseSearch(BufferedReader reader, SearchContentHandler handler) throws IOException, BioException, ParserException {
        this.lineNumber = 0;
        boolean parsedQueryId = false;
        this.handler = handler;
        block8: while ((this.line = reader.readLine()) != null) {
            ++this.lineNumber;
            if (this.line.startsWith(">>><<<")) {
                if (this.searchStatus == 1) {
                    handler.endHeader();
                    handler.endSearch();
                    this.searchParsed = true;
                    this.searchStatus = 0;
                    continue;
                }
                handler.addSubHitProperty("querySeqTokens", this.querySeqTokens.toString());
                handler.addSubHitProperty("subjectSeqTokens", this.subjectSeqTokens.toString());
                handler.addSubHitProperty("matchTokens", this.matchTokens.toString());
                handler.endSubHit();
                handler.endSearch();
                this.searchParsed = true;
                this.searchStatus = 0;
                continue;
            }
            switch (this.searchStatus) {
                case 0: {
                    if (this.line.startsWith(" >")) {
                        String trimmed = this.line.trim();
                        int i = trimmed.indexOf(" ");
                        if (i > 0) {
                            handler.setQuerySeq(trimmed.substring(1, i));
                        } else {
                            handler.setQuerySeq(trimmed.substring(1));
                        }
                    }
                    if (!this.line.startsWith(">>>")) break;
                    this.searchStatus = 1;
                    handler.setSubjectDB(this.parseDB(this.line));
                    handler.startSearch();
                    handler.startHeader();
                    if (!this.searchParsed) break;
                    this.searchParsed = false;
                    handler.setMoreSearches(true);
                    return;
                }
                case 1: {
                    if (this.line.startsWith(">>")) {
                        this.searchStatus = 2;
                        handler.endHeader();
                        handler.startHit();
                        this.querySeqTokens.setLength(0);
                        this.subjectSeqTokens.setLength(0);
                        this.matchTokens.setLength(0);
                        handler.addHitProperty("id", this.parseId(this.line));
                        handler.addHitProperty("desc", this.parseDesc(this.line));
                        break;
                    }
                    if (this.parseHeaderLine(this.line, resultAnnoTokens) || this.parseHeaderLine(this.line, resultSearchParmTokens)) continue block8;
                    throw new ParserException("Fasta parser failed to recognise line type", null, this.lineNumber, this.line);
                }
                case 2: {
                    if (this.line.startsWith(">")) {
                        this.searchStatus = 3;
                        if (!parsedQueryId) {
                            handler.setQuerySeq(this.parseId(this.line));
                            parsedQueryId = true;
                        }
                        handler.endHit();
                        handler.startSubHit();
                        break;
                    }
                    if (this.parseHitLine(this.line, hitAnnoTokens) || this.parseHitLine(this.line, hitDataTokens)) continue block8;
                    throw new ParserException("Fasta parser failed to recognise line type", null, this.lineNumber, this.line);
                }
                case 3: {
                    if (this.line.startsWith(">")) {
                        this.searchStatus = 4;
                        break;
                    }
                    this.parseQuerySequence(this.line);
                    break;
                }
                case 4: {
                    if (this.line.startsWith("; al_cons:")) {
                        this.searchStatus = 5;
                        break;
                    }
                    if (this.line.startsWith(">>")) {
                        this.searchStatus = 2;
                        handler.addSubHitProperty("querySeqTokens", this.querySeqTokens.toString());
                        handler.addSubHitProperty("subjectSeqTokens", this.subjectSeqTokens.toString());
                        handler.addSubHitProperty("matchTokens", this.matchTokens.toString());
                        handler.endSubHit();
                        handler.startHit();
                        this.querySeqTokens.setLength(0);
                        this.subjectSeqTokens.setLength(0);
                        this.matchTokens.setLength(0);
                        handler.addHitProperty("id", this.parseId(this.line));
                        handler.addHitProperty("desc", this.parseDesc(this.line));
                        break;
                    }
                    this.parseSubjectSequence(this.line);
                    break;
                }
                case 5: {
                    if (this.line.startsWith(">>")) {
                        this.searchStatus = 2;
                        handler.addSubHitProperty("querySeqTokens", this.querySeqTokens.toString());
                        handler.addSubHitProperty("subjectSeqTokens", this.subjectSeqTokens.toString());
                        handler.addSubHitProperty("matchTokens", this.matchTokens.toString());
                        handler.endSubHit();
                        handler.startHit();
                        this.querySeqTokens.setLength(0);
                        this.subjectSeqTokens.setLength(0);
                        this.matchTokens.setLength(0);
                        handler.addHitProperty("id", this.parseId(this.line));
                        handler.addHitProperty("desc", this.parseDesc(this.line));
                        break;
                    }
                    if (this.line.startsWith(">>><<<")) {
                        this.searchStatus = 0;
                        handler.addSubHitProperty("querySeqTokens", this.querySeqTokens.toString());
                        handler.addSubHitProperty("subjectSeqTokens", this.subjectSeqTokens.toString());
                        handler.addSubHitProperty("matchTokens", this.matchTokens.toString());
                        handler.endSubHit();
                        handler.endSearch();
                        this.searchParsed = true;
                        handler.setMoreSearches(true);
                        break;
                    }
                    this.matchTokens.append(this.line);
                    break;
                }
            }
        }
        handler.setMoreSearches(false);
    }

    private static Set fillSet(String[] tokenArray, Set set) {
        int i = 0;
        while (i < tokenArray.length) {
            set.add(tokenArray[i]);
            ++i;
        }
        return set;
    }

    private String parseId(String line) throws ParserException {
        String trimmed = line.trim();
        int firstSpace = trimmed.indexOf(32);
        if (trimmed.startsWith(">>")) {
            if (trimmed.length() == 2) {
                throw new ParserException("Fasta parser encountered a sequence with no Id", null, this.lineNumber, line);
            }
            if (firstSpace == -1) {
                return trimmed.substring(2);
            }
            return trimmed.substring(2, firstSpace);
        }
        if (trimmed.length() == 1) {
            throw new ParserException("Fasta parser encountered a sequence with no Id", null, this.lineNumber, line);
        }
        if (firstSpace == -1) {
            return trimmed.substring(1);
        }
        return trimmed.substring(1, firstSpace);
    }

    private String parseDesc(String line) {
        String trimmed = line.trim();
        int firstSpace = trimmed.indexOf(32);
        if (firstSpace == -1) {
            return "No description";
        }
        return trimmed.substring(firstSpace + 1);
    }

    private String parseDB(String line) throws ParserException {
        StringTokenizer st = new StringTokenizer(line);
        String previous = null;
        String current = null;
        while (st.hasMoreTokens()) {
            if (current == null) {
                current = st.nextToken();
                continue;
            }
            previous = current;
            current = st.nextToken();
        }
        if (previous == null) {
            throw new ParserException("Fasta parser failed to parse a database filename", null, this.lineNumber, line);
        }
        return previous;
    }

    private boolean parseHeaderLine(String line, Set tokenSet) throws ParserException {
        String[] data = this.parseLine(line, tokenSet);
        if (data.length > 0) {
            this.handler.addSearchProperty(data[0], data[1]);
            return true;
        }
        return false;
    }

    private boolean parseHitLine(String line, Set tokenSet) throws ParserException {
        String[] data = this.parseLine(line, tokenSet);
        if (data.length > 0) {
            this.handler.addHitProperty(data[0], data[1]);
            return true;
        }
        return false;
    }

    private String[] parseLine(String line, Set tokenSet) throws ParserException {
        int idTokenStart = line.indexOf(";");
        int idTokenEnd = line.indexOf(":");
        String idToken = line.substring(idTokenStart + 1, idTokenEnd);
        idToken = idToken.trim();
        String idValue = line.substring(idTokenEnd + 1);
        idValue = idValue.trim();
        if (tokenSet.contains(idToken)) {
            return new String[]{idToken, idValue};
        }
        return new String[0];
    }

    private void parseQuerySequence(String line) {
        String[] data = this.parseSequence(line);
        if (data.length > 0) {
            this.handler.addSubHitProperty("query" + data[0], data[1]);
        } else {
            this.querySeqTokens.append(line);
        }
    }

    private void parseSubjectSequence(String line) {
        String[] data = this.parseSequence(line);
        if (data.length > 0) {
            this.handler.addSubHitProperty("subject" + data[0], data[1]);
        } else {
            this.subjectSeqTokens.append(line);
        }
    }

    private String[] parseSequence(String line) {
        if (line.startsWith(";")) {
            if (line.equals("; sq_type: p")) {
                return new String[]{"_sq_type", "protein"};
            }
            if (line.equals("; sq_type: D")) {
                return new String[]{"_sq_type", "dna"};
            }
            if (line.startsWith("; al_start:")) {
                return new String[]{"_al_start", this.parseCoord(line)};
            }
            if (line.startsWith("; al_stop:")) {
                return new String[]{"_al_stop", this.parseCoord(line)};
            }
            if (line.startsWith("; al_display_start:")) {
                return new String[]{"_al_display_start", this.parseCoord(line)};
            }
            if (line.startsWith("; sq_len:")) {
                return new String[]{"_sq_len", this.parseCoord(line)};
            }
            if (line.startsWith("; sq_offset:")) {
                return new String[]{"_sq_offset", this.parseCoord(line)};
            }
        }
        return new String[0];
    }

    private String parseCoord(String line) {
        int sepIndex = line.lastIndexOf(":");
        return line.substring(sepIndex + 1).trim();
    }
}

