/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.program.search.SearchContentHandler;
import org.biojava.bio.program.ssbind.AlignmentHandler;
import org.biojava.bio.program.ssbind.BlastDBQueryHandler;
import org.biojava.bio.program.ssbind.DataSetHandler;
import org.biojava.bio.program.ssbind.DatabaseIdHandler;
import org.biojava.bio.program.ssbind.HandlerBinding;
import org.biojava.bio.program.ssbind.HitDescHandler;
import org.biojava.bio.program.ssbind.HitIdHandler;
import org.biojava.bio.program.ssbind.QueryIdHandler;
import org.biojava.bio.program.ssbind.SSPropHandlerFactory;
import org.biojava.bio.program.ssbind.SubHitSummaryHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SeqSimilarityAdapter
extends DefaultHandler {
    private static final ContentHandler empty = new DefaultHandler();
    private static Map hFactories = new HashMap();
    private static Map hContext = new HashMap();
    private List bStack = new ArrayList();
    private HandlerBinding currentBinding;
    private String program = "unknown";
    SearchContentHandler scHandler;

    public SearchContentHandler getSearchContentHandler() {
        return this.scHandler;
    }

    public void setSearchContentHandler(SearchContentHandler scHandler) {
        this.scHandler = scHandler;
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if (localName.equals("HSP")) {
            this.scHandler.startSubHit();
        } else if (localName.equals("Hit")) {
            this.scHandler.startHit();
        } else if (localName.equals("BlastLikeDataSet")) {
            this.scHandler.startSearch();
        } else if (localName.equals("BlastLikeDataSetCollection")) {
            this.scHandler.setMoreSearches(true);
        }
        if (hFactories.containsKey(localName) && this.inContext(localName)) {
            ContentHandler handler = ((SSPropHandlerFactory)hFactories.get(localName)).getHandler(this);
            this.currentBinding = new HandlerBinding(localName, handler);
        } else {
            this.currentBinding = new HandlerBinding(localName, empty);
        }
        this.currentBinding.handler.startElement(uri, localName, qName, attr);
        this.bStack.add(this.currentBinding);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentBinding = (HandlerBinding)this.bStack.remove(this.bStack.size() - 1);
        this.currentBinding.handler.endElement(uri, localName, qName);
        if (localName.equals("HSP")) {
            this.scHandler.endSubHit();
        } else if (localName.equals("Hit")) {
            this.scHandler.endHit();
        } else if (localName.equals("BlastLikeDataSet")) {
            this.scHandler.endSearch();
        } else if (localName.equals("BlastLikeDataSetCollection")) {
            this.scHandler.setMoreSearches(false);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.bStack.isEmpty()) {
            return;
        }
        this.currentBinding = (HandlerBinding)this.bStack.get(this.bStack.size() - 1);
        this.currentBinding.handler.characters(ch, start, length);
    }

    String getProgram() {
        return this.program;
    }

    void setProgram(String program) {
        this.program = program;
    }

    private boolean inContext(String localName) {
        if (!hContext.keySet().contains(localName)) {
            return true;
        }
        String requiredContext = (String)hContext.get(localName);
        int i = this.bStack.size();
        while (--i > 0) {
            if (!((HandlerBinding)this.bStack.get((int)i)).name.equals(requiredContext)) continue;
            return true;
        }
        return false;
    }

    static {
        hFactories.put("BlastLikeDataSet", DataSetHandler.DATASET_HANDLER_FACTORY);
        hFactories.put("RawOutput", BlastDBQueryHandler.BLAST_DBQUERY_HANDLER_FACTORY);
        hFactories.put("DatabaseId", DatabaseIdHandler.DATABASE_ID_HANDLER_FACTORY);
        hFactories.put("QueryId", QueryIdHandler.QUERY_ID_HANDLER_FACTORY);
        hFactories.put("HitId", HitIdHandler.HIT_ID_HANDLER_FACTORY);
        hFactories.put("HitDescription", HitDescHandler.HIT_DESC_HANDLER_FACTORY);
        hFactories.put("HSPSummary", SubHitSummaryHandler.SUBHIT_SUMMARY_HANDLER_FACTORY);
        hFactories.put("QuerySequence", AlignmentHandler.ALIGNMENT_HANDLER_FACTORY);
        hFactories.put("HitSequence", AlignmentHandler.ALIGNMENT_HANDLER_FACTORY);
        hContext.put("RawOutput", "Header");
        hContext.put("HitId", "Hit");
        hContext.put("HitDescription", "Hit");
    }
}

