/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SimpleSeqSimilaritySearchResult
implements SeqSimilaritySearchResult,
Cloneable {
    private SymbolList querySequence;
    private SequenceDB sequenceDB;
    private Map searchParameters;
    private List hits;

    public SimpleSeqSimilaritySearchResult(SymbolList querySequence, SequenceDB sequenceDB, Map searchParameters, List hits) {
        Contract.pre(querySequence != null, "querySequence was null");
        Contract.pre(sequenceDB != null, "sequenceDB was null");
        Contract.pre(hits != null, "hits was null");
        this.querySequence = querySequence;
        this.sequenceDB = sequenceDB;
        this.searchParameters = searchParameters;
        this.hits = hits;
    }

    public SymbolList getQuerySequence() {
        return this.querySequence;
    }

    public SequenceDB getSequenceDB() {
        return this.sequenceDB;
    }

    public Map getSearchParameters() {
        return this.searchParameters == null ? null : Collections.unmodifiableMap(this.searchParameters);
    }

    public List getHits() {
        return Collections.unmodifiableList(this.hits);
    }

    public String toString() {
        return "SimpleSeqSimilaritySearchResult of " + this.getQuerySequence() + " against " + this.getSequenceDB();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchResult that = (SimpleSeqSimilaritySearchResult)o;
        if (!ObjectUtil.equals(this.querySequence, that.querySequence)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceDB, that.sequenceDB)) {
            return false;
        }
        if (!ObjectUtil.equals(this.searchParameters, that.searchParameters)) {
            return false;
        }
        return ObjectUtil.equals(this.hits, that.hits);
    }

    public int hashCode() {
        int hc = 0;
        hc = ObjectUtil.hashCode(hc, this.querySequence);
        hc = ObjectUtil.hashCode(hc, this.sequenceDB);
        hc = ObjectUtil.hashCode(hc, this.searchParameters);
        hc = ObjectUtil.hashCode(hc, this.hits);
        return hc;
    }

    public Object clone() {
        return this;
    }
}

