/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class CircularSequence
extends SimpleSequence {
    public CircularSequence(SymbolList sym, String urn, String name, Annotation annotation) {
        super(sym, urn, name, annotation);
    }

    public CircularSequence(SymbolList sym, String urn, String name, Annotation annotation, FeatureRealizer realizer) {
        super(sym, urn, name, annotation, realizer);
    }

    public Symbol symbolAt(int index) {
        if (index == 0) {
            throw new IllegalArgumentException("Must use a non 0 integer");
        }
        if ((index = (index - 1) % super.length() + 1) < 0) {
            index = super.length() + 1 + index;
        }
        return super.symbolAt(index);
    }

    public String subStr(int start, int end) {
        if (start == 0 || end == 0) {
            throw new IllegalArgumentException("Must use a non 0 integer");
        }
        start = (start - 1) % super.length() + 1;
        end = (end - 1) % super.length() + 1;
        if (start < 0) {
            start = super.length() + 1 + start;
        }
        if (end < 0) {
            end = super.length() + 1 + end;
        }
        if (start <= end) {
            return super.subStr(start, end);
        }
        String toEnd = super.subStr(start, super.length());
        String fromStart = super.subStr(1, end);
        return toEnd + fromStart;
    }

    public SymbolList subList(int start, int end) {
        if (start == 0 || end == 0) {
            throw new IllegalArgumentException("Must use a non 0 integer");
        }
        start = (start - 1) % super.length() + 1;
        end = (end - 1) % super.length() + 1;
        if (start < 0) {
            start = super.length() + 1 + start;
        }
        if (end < 0) {
            end = super.length() + 1 + end;
        }
        if (start <= end) {
            return super.subList(start, end);
        }
        String toEnd = super.subStr(start, super.length());
        String fromStart = super.subStr(1, end);
        String s = toEnd + fromStart;
        try {
            Alphabet alpha = super.getAlphabet();
            SymbolParser sp = alpha.getParser("token");
            SymbolList seq = sp.parse(s);
            return seq;
        }
        catch (BioException be) {
            System.err.println("A serious error has occured during the reconstruction of " + super.getName());
            return null;
        }
    }
}

