/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;

public final class DNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final FiniteAlphabet dna;
    private static final Symbol a;
    private static final Symbol g;
    private static final Symbol c;
    private static final Symbol t;
    private static Map symbolToComplement;

    public static Symbol a() {
        return a;
    }

    public static Symbol g() {
        return g;
    }

    public static Symbol c() {
        return c;
    }

    public static Symbol t() {
        return t;
    }

    public static FiniteAlphabet getDNA() {
        return dna;
    }

    public static SymbolList createDNA(String dna) throws IllegalSymbolException {
        try {
            SymbolParser p = DNATools.getDNA().getParser("token");
            return p.parse(dna);
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with DNA");
        }
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == t) {
            return 3;
        }
        DNATools.getDNA().validate(sym);
        throw new IllegalSymbolException("Really confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return t;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return t;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == t) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        DNATools.getDNA().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        if (token == 'a') {
            return a;
        }
        if (token == 'g') {
            return g;
        }
        if (token == 'c') {
            return c;
        }
        if (token == 't') {
            return t;
        }
        throw new IllegalSymbolException("Unable to find symbol for token " + token);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, DNATools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), DNATools.complementTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    static {
        try {
            dna = (FiniteAlphabet)AlphabetManager.alphabetForName("DNA");
            SymbolList syms = dna.getParser("token").parse("agct");
            a = syms.symbolAt(1);
            g = syms.symbolAt(2);
            c = syms.symbolAt(3);
            t = syms.symbolAt(4);
            symbolToComplement = new HashMap();
            Symbol gap = dna.getGapSymbol();
            symbolToComplement.put(gap, gap);
            Iterator i = ((SimpleAlphabet)dna).ambiguities();
            while (i.hasNext()) {
                Symbol as = (Symbol)i.next();
                HashSet<Symbol> l = new HashSet<Symbol>();
                FiniteAlphabet fa = (FiniteAlphabet)as.getMatches();
                Iterator j = fa.iterator();
                while (j.hasNext()) {
                    l.add(DNATools.complement((Symbol)j.next()));
                }
                symbolToComplement.put(as, dna.getAmbiguity(l));
            }
            complementTable = new DNAComplementTranslationTable();
        }
        catch (Throwable t) {
            throw new BioError(t, "Unable to initialize DNATools");
        }
    }

    private static class DNAComplementTranslationTable
    implements ReversibleTranslationTable {
        private DNAComplementTranslationTable() {
        }

        public Symbol translate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Symbol untranslate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Alphabet getSourceAlphabet() {
            return DNATools.getDNA();
        }

        public Alphabet getTargetAlphabet() {
            return DNATools.getDNA();
        }
    }
}

