/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class LazyFeatureHolder
implements FeatureHolder {
    private FeatureHolder featureHolder;
    private Forwarder changeForwarder;
    protected ChangeSupport changeSupport;

    protected abstract FeatureHolder createFeatureHolder();

    private FeatureHolder getFeatureHolder() {
        if (this.featureHolder == null) {
            this.featureHolder = this.createFeatureHolder();
            if (this.changeSupport != null) {
                this.changeForwarder = new Forwarder();
                this.featureHolder.addChangeListener(this.changeForwarder, ChangeType.UNKNOWN);
            }
        }
        return this.featureHolder;
    }

    public Iterator features() {
        return this.getFeatureHolder().features();
    }

    public int countFeatures() {
        return this.getFeatureHolder().countFeatures();
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatureHolder().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        return this.getFeatureHolder().createFeature(template);
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        this.getFeatureHolder().removeFeature(f);
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatureHolder().containsFeature(f);
    }

    protected void generateChangeSupport() {
        this.changeSupport = new ChangeSupport();
        if (this.featureHolder != null) {
            this.changeForwarder = new Forwarder();
            this.featureHolder.addChangeListener(this.changeForwarder, ChangeType.UNKNOWN);
        }
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeSupport == null) {
            this.generateChangeSupport();
        }
        this.changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.generateChangeSupport();
        }
        this.changeSupport.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(cl, ct);
        }
    }

    private class Forwarder
    implements ChangeListener {
        private Forwarder() {
        }

        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            LazyFeatureHolder.this.changeSupport.firePreChangeEvent(cev);
        }

        public void postChange(ChangeEvent cev) {
            LazyFeatureHolder.this.changeSupport.firePostChangeEvent(cev);
        }
    }
}

