/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleComponentFeature;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.AssembledSymbolList;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleAssembly
implements Sequence,
RealizingFeatureHolder {
    protected transient ChangeSupport changeSupport = null;
    private String name;
    private String uri;
    private Annotation annotation;
    private SimpleFeatureHolder features;
    private AssembledSymbolList assembly;
    private FeatureRealizer featureRealizer = FeatureImpl.DEFAULT;

    public SimpleAssembly(int length, String name, String uri) {
        this.assembly = new AssembledSymbolList();
        this.features = new SimpleFeatureHolder();
        this.name = name;
        this.uri = uri;
        this.assembly.setLength(length);
    }

    public SimpleAssembly(String name, String uri) {
        this.assembly = new AssembledSymbolList();
        this.features = new SimpleFeatureHolder();
        this.name = name;
        this.uri = uri;
    }

    public Alphabet getAlphabet() {
        return this.assembly.getAlphabet();
    }

    public int length() {
        return this.assembly.length();
    }

    public Symbol symbolAt(int pos) {
        return this.assembly.symbolAt(pos);
    }

    public SymbolList subList(int start, int end) {
        return this.assembly.subList(start, end);
    }

    public String seqString() {
        return this.assembly.seqString();
    }

    public String subStr(int start, int end) {
        return this.assembly.subStr(start, end);
    }

    public Iterator iterator() {
        return this.assembly.iterator();
    }

    public List toList() {
        return this.assembly.toList();
    }

    public void edit(Edit e) throws IllegalAlphabetException, ChangeVetoException {
        this.assembly.edit(e);
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.uri;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Iterator features() {
        return this.features.features();
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.features.filter(ff, recurse);
    }

    public boolean containsFeature(Feature f) {
        return this.features.containsFeature(f);
    }

    public Feature createFeature(Feature.Template temp) throws BioException, ChangeVetoException {
        if (temp.location.getMin() < 1) {
            throw new BioException("Coordinates out of range");
        }
        if (temp instanceof ComponentFeature.Template) {
            Iterator i = this.assembly.getComponentLocationSet().iterator();
            while (i.hasNext()) {
                Location l = (Location)i.next();
                if (!l.overlaps(temp.location)) continue;
                throw new BioError("Can't create overlapping ComponentFeature");
            }
        }
        Feature f = this.realizeFeature(this, temp);
        this.features.addFeature(f);
        if (f instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)f;
            Location loc = cf.getLocation();
            if (loc.getMax() > this.assembly.length()) {
                this.assembly.setLength(loc.getMax());
            }
            this.assembly.putComponent(loc, cf);
        }
        return f;
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        if (f instanceof ComponentFeature) {
            this.assembly.removeComponent(f.getLocation());
        }
        this.features.removeFeature(f);
    }

    public Feature realizeFeature(FeatureHolder fh, Feature.Template temp) throws BioException {
        if (temp instanceof ComponentFeature.Template) {
            if (fh != this) {
                throw new BioException("ComponentFeatures can only be attached directly to SimpleAssembly objects");
            }
            ComponentFeature.Template cft = (ComponentFeature.Template)temp;
            return new SimpleComponentFeature(this, cft);
        }
        FeatureHolder gopher = fh;
        while (gopher instanceof Feature) {
            if (gopher instanceof ComponentFeature) {
                throw new BioException("Cannot [currently] realize features on components of SimpleAssemblies");
            }
            gopher = ((Feature)gopher).getParent();
        }
        return this.featureRealizer.realizeFeature(this, fh, temp);
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl);
            }
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl, ct);
            }
        }
    }
}

